/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.GetAclParams;

public class UssGetAcl {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssGetAcl(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssGetAcl(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public String get(String targetPath, boolean useCommas) throws ZosmfRequestException {
        Response response = useCommas ? this.getAclCommon(targetPath, new GetAclParams.Builder().usecommas(true).build()) : this.getAclCommon(targetPath, new GetAclParams.Builder().build());
        JSONObject json = JsonParserUtil.parse(response.getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned")).toString());
        StringBuilder str = new StringBuilder();
        if (useCommas) {
            ((JSONArray)json.get("stdout")).forEach(item -> str.append(item.toString()));
        } else {
            ((JSONArray)json.get("stdout")).forEach(item -> str.append(item.toString()).append("\n"));
        }
        return str.toString();
    }

    public Response getAclCommon(String targetPath, GetAclParams params) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(targetPath, "targetPath");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, Object> getAclMap = new HashMap<String, Object>();
        getAclMap.put("request", "getfacl");
        params.getType().ifPresent(type -> getAclMap.put("type", type.getValue()));
        params.getUser().ifPresent(user -> getAclMap.put("user", user));
        if (params.getUseCommas()) {
            getAclMap.put("use-commas", params.getUseCommas());
        }
        if (params.getSuppressHeader()) {
            getAclMap.put("suppress-header", params.getSuppressHeader());
        }
        if (params.getSuppressBaseAcl()) {
            getAclMap.put("suppress-baseacl", params.getSuppressBaseAcl());
        }
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(getAclMap).toString());
        return this.request.executeRequest();
    }
}

