/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class ChangeModeParams {
    private final Optional<String> mode;
    private final boolean recursive;
    private final Optional<LinkType> links;

    public ChangeModeParams(Builder builder) {
        this.mode = Optional.of(builder.mode);
        this.recursive = builder.recursive;
        this.links = Optional.ofNullable(builder.links);
    }

    public Optional<String> getMode() {
        return this.mode;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Optional<LinkType> getLinks() {
        return this.links;
    }

    public String toString() {
        return "ChangeModeParams{mode=" + this.mode + ", recursive=" + this.recursive + ", links=" + this.links + "}";
    }

    public static class Builder {
        private String mode;
        private boolean recursive = false;
        private LinkType links;

        public Builder mode(String mode) {
            ValidateUtils.checkNullParameter(mode == null, "mode is null");
            ValidateUtils.checkIllegalParameter(mode.isBlank(), "mode not specified");
            this.mode = mode;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder links(LinkType type) {
            this.links = type;
            return this;
        }

        public ChangeModeParams build() {
            return new ChangeModeParams(this);
        }
    }
}

