/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetStreamZosmfRequest;
import zowe.client.sdk.rest.GetTextZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.GetParams;

public class UssGet {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssGet(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssGet(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        this.request = request;
    }

    public byte[] getBinary(String fileNamePath) throws ZosmfRequestException {
        GetParams params = new GetParams.Builder().binary(true).build();
        Response response = this.getCommon(fileNamePath, params);
        return (byte[])response.getResponsePhrase().orElse(new byte[0]);
    }

    public String getText(String fileNamePath) throws ZosmfRequestException {
        GetParams params = new GetParams.Builder().build();
        Response response = this.getCommon(fileNamePath, params);
        return (String)response.getResponsePhrase().orElse("");
    }

    public Response getCommon(String fileNamePath, GetParams params) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fileNamePath, "fileNamePath");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        StringBuilder url = new StringBuilder(this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(fileNamePath)));
        params.getSearch().ifPresent(str -> url.append("?search=").append(EncodeUtils.encodeURIComponent(str)));
        params.getResearch().ifPresent(str -> url.append("?research=").append(EncodeUtils.encodeURIComponent(str)));
        if (!params.isInsensitive()) {
            if (params.getQueryCount() > 1) {
                url.append("&insensitive=false");
            } else {
                url.append("?insensitive=false");
            }
        }
        params.getMaxReturnSize().ifPresent(size -> {
            if (params.getQueryCount() > 1) {
                url.append("&maxreturnsize=").append(size);
            } else {
                url.append("?maxreturnsize=").append(size);
            }
        });
        HashMap<String, String> headers = new HashMap<String, String>();
        if (params.isBinary()) {
            headers.put("X-IBM-Data-Type", "binary");
            if (this.request == null || !(this.request instanceof GetStreamZosmfRequest)) {
                this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_STREAM);
            }
        } else {
            headers.put("X-IBM-Data-Type", "text");
            if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
                this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
            }
        }
        params.getRecordsRange().ifPresent(range -> headers.put("X-IBM-Record-Range", (String)range));
        this.request.setHeaders(headers);
        this.request.setUrl(url.toString());
        return this.request.executeRequest();
    }
}

