/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.ModifyJobParams;
import zowe.client.sdk.zosjobs.response.Job;

public class JobCancel {
    private static final Logger LOG = LoggerFactory.getLogger(JobCancel.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public JobCancel(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    JobCancel(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest) && !(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON or DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response cancel(String jobName, String jobId, String version) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName is either null or empty");
        ValidateUtils.checkIllegalParameter(jobId, "jobId is either null or empty");
        ValidateUtils.checkIllegalParameter(version, "version");
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response cancelByJob(Job job, String version) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        ValidateUtils.checkIllegalParameter(version, "version");
        String jobName = job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty"));
        String jobId = job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty"));
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).version(version).build());
    }

    public Response cancelPurge(String jobName, String jobId, String version) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName is either null or empty");
        ValidateUtils.checkIllegalParameter(jobId, "jobId is either null or empty");
        ValidateUtils.checkIllegalParameter(version, "version");
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).purge(true).version(version).build());
    }

    public Response cancelPurgeByJob(Job job, String version) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        ValidateUtils.checkIllegalParameter(version, "version");
        String jobName = job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty"));
        String jobId = job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty"));
        return this.cancelCommon(new ModifyJobParams.Builder(jobName, jobId).purge(true).version(version).build());
    }

    public Response cancelCommon(ModifyJobParams params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + params.getJobName().get() + "/" + params.getJobId().get();
        String version = params.getVersion().orElse("1.0");
        if ("1.0".equals(version)) {
            LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
        } else if ("2.0".equals(version)) {
            LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
        } else {
            throw new IllegalArgumentException("invalid version specified");
        }
        HashMap<String, String> cancelMap = new HashMap<String, String>();
        cancelMap.put("request", "cancel");
        cancelMap.put("version", version);
        if (this.request == null && !params.isPurge()) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
            this.request.setBody(new JSONObject(cancelMap).toString());
        } else if (this.request == null && params.isPurge()) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
            this.request.setHeaders(Map.of("X-IBM-Job-Modify-Version", version));
        }
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

