/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;

public class ModifyJobParams {
    private final Optional<String> jobName;
    private final Optional<String> jobId;
    private final Optional<String> version;
    public final boolean purge;

    private ModifyJobParams(Builder builder) {
        this.jobName = Optional.ofNullable(builder.jobName);
        this.jobId = Optional.ofNullable(builder.jobId);
        this.version = Optional.ofNullable(builder.version);
        this.purge = builder.purge;
    }

    public Optional<String> getJobId() {
        return this.jobId;
    }

    public Optional<String> getJobName() {
        return this.jobName;
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public String toString() {
        return "ModifyJobParams{jobId=" + this.jobId + ", jobName=" + this.jobName + ", version=" + this.version + "}";
    }

    public static class Builder {
        private final String jobName;
        private final String jobId;
        private String version;
        private boolean purge = false;

        public Builder(String jobName, String jobId) {
            this.jobName = jobName;
            this.jobId = jobId;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder purge(boolean purge) {
            this.purge = purge;
            return this;
        }

        public ModifyJobParams build() {
            return new ModifyJobParams(this);
        }
    }
}

