/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.input;

import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalLong;

public class DownloadParams {
    private final Optional<String> file;
    private final Optional<String> extension;
    private final Optional<String> directory;
    private final Optional<String[]> excludePatterns;
    private final Optional<HashMap<String, String>> extensionMap;
    private final OptionalLong maxConcurrentRequests;
    private final boolean returnEtag;
    private final boolean preserveOriginalLetterCase;
    private final boolean failFast;
    private final boolean binary;
    private final OptionalLong encoding;
    private final Optional<String> volume;
    private final Optional<String> task;
    private final Optional<String> responseTimeout;

    private DownloadParams(Builder builder) {
        this.file = Optional.ofNullable(builder.file);
        this.extension = Optional.ofNullable(builder.extension);
        this.directory = Optional.ofNullable(builder.directory);
        this.excludePatterns = Optional.ofNullable(builder.excludePatterns);
        this.extensionMap = Optional.ofNullable(builder.extensionMap);
        this.maxConcurrentRequests = builder.maxConcurrentRequests == null ? OptionalLong.empty() : OptionalLong.of(builder.maxConcurrentRequests);
        this.returnEtag = builder.returnEtag;
        this.preserveOriginalLetterCase = builder.preserveOriginalLetterCase;
        this.failFast = builder.failFast;
        this.binary = builder.binary;
        this.encoding = builder.encoding == null ? OptionalLong.empty() : OptionalLong.of(builder.encoding);
        this.volume = Optional.ofNullable(builder.volume);
        this.task = Optional.ofNullable(builder.task);
        this.responseTimeout = Optional.ofNullable(builder.responseTimeout);
    }

    public boolean isBinary() {
        return this.binary;
    }

    public Optional<String> getDirectory() {
        return this.directory;
    }

    public OptionalLong getEncoding() {
        return this.encoding;
    }

    public Optional<String[]> getExcludePatterns() {
        return this.excludePatterns;
    }

    public Optional<String> getExtension() {
        return this.extension;
    }

    public Optional<HashMap<String, String>> getExtensionMap() {
        return this.extensionMap;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public Optional<String> getFile() {
        return this.file;
    }

    public OptionalLong getNaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public boolean isPreserveOriginalLetterCase() {
        return this.preserveOriginalLetterCase;
    }

    public Optional<String> getResponseTimeout() {
        return this.responseTimeout;
    }

    public boolean isReturnEtag() {
        return this.returnEtag;
    }

    public Optional<String> getTask() {
        return this.task;
    }

    public Optional<String> getVolume() {
        return this.volume;
    }

    public String toString() {
        return "DownloadOptions{file=" + this.file + ", extension=" + this.extension + ", directory=" + this.directory + ", excludePatterns=" + this.excludePatterns + ", extensionMap=" + this.extensionMap + ", maxConcurrentRequests=" + this.maxConcurrentRequests + ", returnEtag=" + this.returnEtag + ", preserveOriginalLetterCase=" + this.preserveOriginalLetterCase + ", failFast=" + this.failFast + ", binary=" + this.binary + ", encoding=" + this.encoding + ", volume=" + this.volume + ", task=" + this.task + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String file;
        private String extension;
        private String directory;
        private String[] excludePatterns;
        private HashMap<String, String> extensionMap;
        private Long maxConcurrentRequests;
        private boolean returnEtag;
        private boolean preserveOriginalLetterCase;
        private boolean failFast;
        private boolean binary;
        private Long encoding;
        private String volume;
        private String task;
        private String responseTimeout;

        public Builder binary(boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public Builder encoding(Long encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder excludePatterns(String[] excludePatterns) {
            this.excludePatterns = excludePatterns;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder extensionMap(HashMap<String, String> extensionMap) {
            this.extensionMap = extensionMap;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder maxConcurrentRequests(Long maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
            return this;
        }

        public Builder preserveOriginalLetterCase(boolean preserveOriginalLetterCase) {
            this.preserveOriginalLetterCase = preserveOriginalLetterCase;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder returnEtag(boolean returnEtag) {
            this.returnEtag = returnEtag;
            return this;
        }

        public Builder task(String task) {
            this.task = task;
            return this;
        }

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public DownloadParams build() {
            return new DownloadParams(this);
        }
    }
}

