/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfauth.methods;

import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfauth.response.ZosmfLoginResponse;

public class ZosmfLogin {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfLogin(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    ZosmfLogin(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfLoginResponse login() throws ZosmfRequestException {
        String url = this.connection.getZosmfUrl() + "/services/authenticate";
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        Response response = this.request.executeRequest();
        return new ZosmfLoginResponse(response, response.getTokens());
    }
}

