/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.method;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.input.IssueConsoleParams;
import zowe.client.sdk.zosconsole.response.ConsoleResponse;
import zowe.client.sdk.zosconsole.response.ZosmfIssueResponse;
import zowe.client.sdk.zosconsole.service.ConsoleResponseService;

public class IssueConsole {
    private static final String CMD = "cmd";
    private static final String SOL_KEY = "sol-key";
    private static final String SYSTEM = "system";
    private final ZosConnection connection;
    private ZosmfRequest request;

    public IssueConsole(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    IssueConsole(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public ConsoleResponse issueCommand(String command) throws ZosmfRequestException {
        return this.issueCommandCommon("defcn", new IssueConsoleParams(command));
    }

    public ConsoleResponse issueCommand(String command, String consoleName) throws ZosmfRequestException {
        return this.issueCommandCommon(consoleName, new IssueConsoleParams(command));
    }

    public ConsoleResponse issueCommandCommon(String consoleName, IssueConsoleParams params) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(consoleName, "consoleName");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = this.connection.getZosmfUrl() + "/restconsoles/consoles/" + EncodeUtils.encodeURIComponent(consoleName);
        Map<String, String> issueMap = this.getIssueMap(params);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(issueMap).toString());
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no issue console response phrase")).toString();
        JSONObject jsonObject = JsonParserUtil.parse(jsonStr);
        return ConsoleResponseService.getInstance().buildConsoleResponse((ZosmfIssueResponse)JsonParseFactory.buildParser(ParseType.MVS_CONSOLE).parseResponse(jsonObject), params.isProcessResponse());
    }

    private Map<String, String> getIssueMap(IssueConsoleParams params) {
        HashMap<String, String> issueMap = new HashMap<String, String>();
        issueMap.put(CMD, params.getCmd());
        params.getSolKey().ifPresent(solKey -> issueMap.put(SOL_KEY, (String)solKey));
        params.getSystem().ifPresent(sys -> issueMap.put(SYSTEM, (String)sys));
        return issueMap;
    }
}

