/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.DeleteAclType;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class UssSetAclInputData {
    private final boolean abort;
    private final LinkType links;
    private final DeleteAclType deleteType;
    private final String set;
    private final String modify;
    private final String delete;

    public UssSetAclInputData(Builder builder) {
        this.abort = builder.abort;
        this.links = builder.links;
        this.deleteType = builder.deleteType;
        this.set = builder.set;
        this.modify = builder.modify;
        this.delete = builder.delete;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public Optional<LinkType> getLinks() {
        return Optional.ofNullable(this.links);
    }

    public Optional<DeleteAclType> getDeleteType() {
        return Optional.ofNullable(this.deleteType);
    }

    public Optional<String> getSet() {
        return Optional.ofNullable(this.set);
    }

    public Optional<String> getModify() {
        return Optional.ofNullable(this.modify);
    }

    public Optional<String> getDelete() {
        return Optional.ofNullable(this.delete);
    }

    public String toString() {
        return "UssSetAclInputData{abort=" + this.abort + ", links=" + this.links + ", deleteType=" + this.deleteType + ", set=" + this.set + ", modify=" + this.modify + ", delete=" + this.delete + "}";
    }

    public static class Builder {
        private boolean abort = false;
        private LinkType links = LinkType.FOLLOW;
        private DeleteAclType deleteType;
        private String set;
        private String modify;
        private String delete;

        public Builder setAbort(boolean abort) {
            this.abort = abort;
            return this;
        }

        public Builder setLinks(LinkType links) {
            this.links = links;
            return this;
        }

        public Builder setDeleteType(DeleteAclType deleteType) {
            ValidateUtils.checkNullParameter(deleteType == null, "deleteType is null");
            this.deleteType = deleteType;
            return this;
        }

        public Builder setSet(String set) {
            ValidateUtils.checkNullParameter(set == null, "set is null");
            ValidateUtils.checkIllegalParameter(set.isBlank(), "set not specified");
            this.set = set;
            return this;
        }

        public Builder setModify(String modify) {
            ValidateUtils.checkNullParameter(modify == null, "modify is null");
            ValidateUtils.checkIllegalParameter(modify.isBlank(), "modify not specified");
            this.modify = modify;
            return this;
        }

        public Builder setDelete(String delete) {
            ValidateUtils.checkNullParameter(delete == null, "delete is null");
            ValidateUtils.checkIllegalParameter(delete.isBlank(), "delete not specified");
            this.delete = delete;
            return this;
        }

        public UssSetAclInputData build() {
            return new UssSetAclInputData(this);
        }
    }
}

