/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.response;

import java.util.Optional;
import java.util.OptionalLong;
import zowe.client.sdk.zosjobs.response.JobStepData;

public class Job {
    private final String jobId;
    private final String jobName;
    private final String subSystem;
    private final String owner;
    private final String status;
    private final String type;
    private final String classs;
    private final String retCode;
    private final JobStepData[] stepData;
    private final String url;
    private final String filesUrl;
    private final String jobCorrelator;
    private final Long phase;
    private final String phaseName;

    private Job(Builder builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.subSystem = builder.subSystem;
        this.owner = builder.owner;
        this.status = builder.status;
        this.type = builder.type;
        this.classs = builder.classs;
        this.retCode = builder.retCode;
        this.stepData = builder.stepData;
        this.url = builder.url;
        this.filesUrl = builder.filesUrl;
        this.jobCorrelator = builder.jobCorrelator;
        this.phase = builder.phase;
        this.phaseName = builder.phaseName;
    }

    public Optional<String> getClasss() {
        return Optional.ofNullable(this.classs);
    }

    public Optional<String> getFilesUrl() {
        return Optional.ofNullable(this.filesUrl);
    }

    public Optional<String> getJobCorrelator() {
        return Optional.ofNullable(this.jobCorrelator);
    }

    public Optional<String> getJobId() {
        return Optional.ofNullable(this.jobId);
    }

    public Optional<String> getJobName() {
        return Optional.ofNullable(this.jobName);
    }

    public Optional<String> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public OptionalLong getPhase() {
        return this.phase == null ? OptionalLong.empty() : OptionalLong.of(this.phase);
    }

    public Optional<String> getPhaseName() {
        return Optional.ofNullable(this.phaseName);
    }

    public Optional<String> getRetCode() {
        return Optional.ofNullable(this.retCode);
    }

    public Optional<String> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public Optional<JobStepData[]> getStepData() {
        return Optional.ofNullable(this.stepData);
    }

    public Optional<String> getSubSystem() {
        return Optional.ofNullable(this.subSystem);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public String toString() {
        return "Job{jobId=" + this.jobId + ", jobName=" + this.jobName + ", subSystem=" + this.subSystem + ", owner=" + this.owner + ", status=" + this.status + ", type=" + this.type + ", classs=" + this.classs + ", retCode=" + this.retCode + ", stepData=" + this.stepData + ", url=" + this.url + ", filesUrl=" + this.filesUrl + ", jobCorrelator=" + this.jobCorrelator + ", phase=" + this.phase + ", phaseName=" + this.phaseName + "}";
    }

    public static class Builder {
        private String jobId;
        private String jobName;
        private String subSystem;
        private String owner;
        private String status;
        private String type;
        private String classs;
        private String retCode;
        private JobStepData[] stepData;
        private String url;
        private String filesUrl;
        private String jobCorrelator;
        private Long phase;
        private String phaseName;

        public Builder classs(String classs) {
            this.classs = classs;
            return this;
        }

        public Builder filesUrl(String filesUrl) {
            this.filesUrl = filesUrl;
            return this;
        }

        public Builder jobCorrelator(String jobCorrelator) {
            this.jobCorrelator = jobCorrelator;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder phase(Long phase) {
            this.phase = phase;
            return this;
        }

        public Builder phaseName(String phaseName) {
            this.phaseName = phaseName;
            return this;
        }

        public Builder retCode(String retCode) {
            this.retCode = retCode;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder stepData(JobStepData[] stepData) {
            this.stepData = stepData;
            return this;
        }

        public Builder subSystem(String subSystem) {
            this.subSystem = subSystem;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Job build() {
            return new Job(this);
        }
    }
}

