/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.method;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StartTsoInputData;
import zowe.client.sdk.zostso.service.TsoReplyService;
import zowe.client.sdk.zostso.service.TsoSendService;
import zowe.client.sdk.zostso.service.TsoStartService;
import zowe.client.sdk.zostso.service.TsoStopService;

public class IssueTso {
    private final List<String> msgLst = new ArrayList<String>();
    private final List<String> promptLst = new ArrayList<String>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ZosConnection connection;
    private final String accountNumber;
    private TsoStartService tsoStartService;
    private TsoStopService tsoStopService;
    private TsoSendService tsoSendService;
    private TsoReplyService tsoReplyService;
    private StartTsoInputData inputData;

    public IssueTso(ZosConnection connection, String accountNumber) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkIllegalParameter(accountNumber, "accountNumber");
        this.connection = connection;
        this.accountNumber = accountNumber;
    }

    IssueTso(ZosConnection connection, String accountNumber, TsoStartService tsoStartService, TsoStopService tsoStopService, TsoSendService tsoSendService, TsoReplyService tsoReplyService) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
        this.accountNumber = accountNumber;
        this.tsoStartService = tsoStartService;
        this.tsoStopService = tsoStopService;
        this.tsoSendService = tsoSendService;
        this.tsoReplyService = tsoReplyService;
    }

    public List<String> issueCommand(String command) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(command, "command");
        return this.issueCommand(command, null);
    }

    public List<String> issueCommand(String command, StartTsoInputData inputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(command, "command");
        this.msgLst.clear();
        this.promptLst.clear();
        String sessionId = this.startTso(inputData);
        String responseStr = this.sendTsoCommand(sessionId, command);
        JsonNode tsoData = this.getJsonNode(responseStr).get("tsoData");
        this.processTsoData(tsoData);
        boolean tsoMessagesReceived = false;
        while (!tsoMessagesReceived) {
            responseStr = this.sendTsoForReply(sessionId);
            tsoData = this.getJsonNode(responseStr).get("tsoData");
            this.processTsoData(tsoData);
            if (this.promptLst.isEmpty()) continue;
            tsoMessagesReceived = true;
        }
        this.stopTso(sessionId);
        return this.msgLst;
    }

    private String startTso(StartTsoInputData inputData) throws ZosmfRequestException {
        if (this.tsoStartService == null) {
            this.tsoStartService = new TsoStartService(this.connection);
        }
        this.inputData = inputData;
        if (this.inputData == null) {
            this.inputData = new StartTsoInputData();
            this.inputData.setAccount(this.accountNumber);
        } else if (this.inputData.getAccount().isEmpty()) {
            this.inputData.setAccount(this.accountNumber);
        }
        return this.tsoStartService.startTso(this.inputData);
    }

    private String sendTsoCommand(String sessionId, String command) throws ZosmfRequestException {
        if (this.tsoSendService == null) {
            this.tsoSendService = new TsoSendService(this.connection);
        }
        return this.tsoSendService.sendCommand(sessionId, command);
    }

    private String sendTsoForReply(String sessionId) throws ZosmfRequestException {
        if (this.tsoReplyService == null) {
            this.tsoReplyService = new TsoReplyService(this.connection);
        }
        return this.tsoReplyService.reply(sessionId);
    }

    private void stopTso(String sessionId) throws ZosmfRequestException {
        if (this.tsoStopService == null) {
            this.tsoStopService = new TsoStopService(this.connection);
        }
        this.tsoStopService.stopTso(sessionId);
    }

    private void processTsoData(JsonNode tsoData) {
        if (tsoData == null || !tsoData.isArray()) {
            return;
        }
        tsoData.forEach(tsoDataItem -> {
            JsonNode promptNode;
            JsonNode messageNode = tsoDataItem.get("TSO MESSAGE");
            if (messageNode != null && messageNode.hasNonNull("DATA")) {
                this.msgLst.add(messageNode.get("DATA").asText());
            }
            if ((promptNode = tsoDataItem.get("TSO PROMPT")) != null && promptNode.hasNonNull("HIDDEN")) {
                this.promptLst.add(promptNode.get("HIDDEN").asText());
            }
        });
    }

    private JsonNode getJsonNode(String responseStr) throws ZosmfRequestException {
        JsonNode rootNode;
        try {
            rootNode = this.objectMapper.readTree(responseStr);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException("Failed to send tso for data. Response: " + e.getMessage());
        }
        return rootNode;
    }

    StartTsoInputData getInputData() {
        return this.inputData;
    }
}

