/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.model;

import java.util.Optional;
import java.util.OptionalLong;

public class Member {
    private final String member;
    private final Long vers;
    private final Long mod;
    private final String c4date;
    private final String m4date;
    private final Long cnorc;
    private final Long inorc;
    private final Long mnorc;
    private final String mtime;
    private final String msec;
    private final String user;
    private final String sclm;

    private Member(Builder builder) {
        this.member = builder.member;
        this.vers = builder.vers;
        this.mod = builder.mod;
        this.c4date = builder.c4date;
        this.m4date = builder.m4date;
        this.cnorc = builder.cnorc;
        this.inorc = builder.inorc;
        this.mnorc = builder.mnorc;
        this.mtime = builder.mtime;
        this.msec = builder.msec;
        this.user = builder.user;
        this.sclm = builder.sclm;
    }

    public Optional<String> getMember() {
        return Optional.ofNullable(this.member);
    }

    public OptionalLong getVers() {
        return this.vers == null ? OptionalLong.empty() : OptionalLong.of(this.vers);
    }

    public OptionalLong getMod() {
        return this.mod == null ? OptionalLong.empty() : OptionalLong.of(this.mod);
    }

    public Optional<String> getC4date() {
        return Optional.ofNullable(this.c4date);
    }

    public Optional<String> getM4date() {
        return Optional.ofNullable(this.m4date);
    }

    public OptionalLong getCnorc() {
        return this.cnorc == null ? OptionalLong.empty() : OptionalLong.of(this.cnorc);
    }

    public OptionalLong getInorc() {
        return this.inorc == null ? OptionalLong.empty() : OptionalLong.of(this.inorc);
    }

    public OptionalLong getMnorc() {
        return this.mnorc == null ? OptionalLong.empty() : OptionalLong.of(this.mnorc);
    }

    public Optional<String> getMtime() {
        return Optional.ofNullable(this.mtime);
    }

    public Optional<String> getMsec() {
        return Optional.ofNullable(this.msec);
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public Optional<String> getSclm() {
        return Optional.ofNullable(this.sclm);
    }

    public String toString() {
        return "Member{member=" + this.member + ", vers=" + this.vers + ", mod=" + this.mod + ", c4date=" + this.c4date + ", m4date=" + this.m4date + ", cnorc=" + this.cnorc + ", inorc=" + this.inorc + ", mnorc=" + this.mnorc + ", mtime=" + this.mtime + ", msec=" + this.msec + ", user=" + this.user + ", sclm=" + this.sclm + "}";
    }

    public static class Builder {
        private String member;
        private Long vers;
        private Long mod;
        private String c4date;
        private String m4date;
        private Long cnorc;
        private Long inorc;
        private Long mnorc;
        private String mtime;
        private String msec;
        private String user;
        private String sclm;

        public Builder member(String member) {
            this.member = member;
            return this;
        }

        public Builder vers(Long vers) {
            this.vers = vers;
            return this;
        }

        public Builder mod(Long mod) {
            this.mod = mod;
            return this;
        }

        public Builder c4date(String c4date) {
            this.c4date = c4date;
            return this;
        }

        public Builder m4date(String m4date) {
            this.m4date = m4date;
            return this;
        }

        public Builder cnorc(Long cnorc) {
            this.cnorc = cnorc;
            return this;
        }

        public Builder inorc(Long inorc) {
            this.inorc = inorc;
            return this;
        }

        public Builder mnorc(Long mnorc) {
            this.mnorc = mnorc;
            return this;
        }

        public Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder msec(String msec) {
            this.msec = msec;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder sclm(String sclm) {
            this.sclm = sclm;
            return this;
        }

        public Member build() {
            return new Member(this);
        }
    }
}

