/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.input;

import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalLong;

public class DsnDownloadInputData {
    private final String file;
    private final String extension;
    private final String directory;
    private final String[] excludePatterns;
    private final HashMap<String, String> extensionMap;
    private final Long maxConcurrentRequests;
    private final boolean returnEtag;
    private final boolean preserveOriginalLetterCase;
    private final boolean failFast;
    private final boolean binary;
    private final Long encoding;
    private final String volume;
    private final String task;
    private final String responseTimeout;

    private DsnDownloadInputData(Builder builder) {
        this.file = builder.file;
        this.extension = builder.extension;
        this.directory = builder.directory;
        this.excludePatterns = builder.excludePatterns;
        this.extensionMap = builder.extensionMap;
        this.maxConcurrentRequests = builder.maxConcurrentRequests;
        this.returnEtag = builder.returnEtag;
        this.preserveOriginalLetterCase = builder.preserveOriginalLetterCase;
        this.failFast = builder.failFast;
        this.binary = builder.binary;
        this.encoding = builder.encoding;
        this.volume = builder.volume;
        this.task = builder.task;
        this.responseTimeout = builder.responseTimeout;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public Optional<String> getDirectory() {
        return Optional.ofNullable(this.directory);
    }

    public OptionalLong getEncoding() {
        return this.encoding == null ? OptionalLong.empty() : OptionalLong.of(this.encoding);
    }

    public Optional<String[]> getExcludePatterns() {
        return Optional.ofNullable(this.excludePatterns);
    }

    public Optional<String> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    public Optional<HashMap<String, String>> getExtensionMap() {
        return Optional.ofNullable(this.extensionMap);
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public Optional<String> getFile() {
        return Optional.ofNullable(this.file);
    }

    public OptionalLong getNaxConcurrentRequests() {
        return this.maxConcurrentRequests == null ? OptionalLong.empty() : OptionalLong.of(this.maxConcurrentRequests);
    }

    public boolean isPreserveOriginalLetterCase() {
        return this.preserveOriginalLetterCase;
    }

    public Optional<String> getResponseTimeout() {
        return Optional.ofNullable(this.responseTimeout);
    }

    public boolean isReturnEtag() {
        return this.returnEtag;
    }

    public Optional<String> getTask() {
        return Optional.ofNullable(this.task);
    }

    public Optional<String> getVolume() {
        return Optional.ofNullable(this.volume);
    }

    public String toString() {
        return "DsnDownloadInputData{file=" + this.file + ", extension=" + this.extension + ", directory=" + this.directory + ", excludePatterns=" + this.excludePatterns + ", extensionMap=" + this.extensionMap + ", maxConcurrentRequests=" + this.maxConcurrentRequests + ", returnEtag=" + this.returnEtag + ", preserveOriginalLetterCase=" + this.preserveOriginalLetterCase + ", failFast=" + this.failFast + ", binary=" + this.binary + ", encoding=" + this.encoding + ", volume=" + this.volume + ", task=" + this.task + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String file;
        private String extension;
        private String directory;
        private String[] excludePatterns;
        private HashMap<String, String> extensionMap;
        private Long maxConcurrentRequests;
        private boolean returnEtag;
        private boolean preserveOriginalLetterCase;
        private boolean failFast;
        private boolean binary;
        private Long encoding;
        private String volume;
        private String task;
        private String responseTimeout;

        public Builder binary(boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public Builder encoding(Long encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder excludePatterns(String[] excludePatterns) {
            this.excludePatterns = excludePatterns;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder extensionMap(HashMap<String, String> extensionMap) {
            this.extensionMap = extensionMap;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder maxConcurrentRequests(Long maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
            return this;
        }

        public Builder preserveOriginalLetterCase(boolean preserveOriginalLetterCase) {
            this.preserveOriginalLetterCase = preserveOriginalLetterCase;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder returnEtag(boolean returnEtag) {
            this.returnEtag = returnEtag;
            return this;
        }

        public Builder task(String task) {
            this.task = task;
            return this;
        }

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public DsnDownloadInputData build() {
            return new DsnDownloadInputData(this);
        }
    }
}

