/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.DsnCreateInputData;

public class DsnCreate {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnCreate(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    DsnCreate(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PostJsonZosmfRequest)) {
            throw new IllegalStateException("POST_JSON request type required");
        }
        this.request = request;
    }

    public Response create(String dataSetName, DsnCreateInputData createInputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(dataSetName, "dataSetName");
        ValidateUtils.checkNullParameter(createInputData == null, "createInputData is null");
        String url = this.connection.getZosmfUrl() + "/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName);
        HashMap createMap = new HashMap();
        createInputData.getVolser().ifPresent(v -> createMap.put("volser", v));
        createInputData.getUnit().ifPresent(v -> createMap.put("unit", v));
        createInputData.getDsorg().ifPresent(v -> createMap.put("dsorg", v));
        createInputData.getAlcunit().ifPresent(v -> createMap.put("alcunit", v));
        createInputData.getPrimary().ifPresent(v -> createMap.put("primary", v));
        createInputData.getSecondary().ifPresent(v -> createMap.put("secondary", v));
        createInputData.getDirblk().ifPresent(v -> createMap.put("dirblk", v));
        createInputData.getAvgblk().ifPresent(v -> createMap.put("avgblk", v));
        createInputData.getRecfm().ifPresent(v -> createMap.put("recfm", v));
        createInputData.getBlksize().ifPresent(v -> createMap.put("blksize", v));
        createInputData.getLrecl().ifPresent(v -> createMap.put("lrecl", v));
        createInputData.getStorclass().ifPresent(v -> createMap.put("storclass", v));
        createInputData.getStorclass().ifPresent(v -> createMap.put("mgntclass", v));
        createInputData.getMgntclass().ifPresent(v -> createMap.put("mgntclass", v));
        createInputData.getDataclass().ifPresent(v -> createMap.put("dataclass", v));
        createInputData.getDsntype().ifPresent(v -> createMap.put("dsntype", v));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject((Map)createMap).toString());
        return this.request.executeRequest();
    }
}

