/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.model;

import java.util.Optional;
import java.util.OptionalLong;

public class UnixFile {
    private final String name;
    private final String mode;
    private final Long size;
    private final Long uid;
    private final String user;
    private final Long gid;
    private final String group;
    private final String mtime;
    private final String target;

    public UnixFile(Builder builder) {
        this.name = builder.name;
        this.mode = builder.mode;
        this.size = builder.size;
        this.uid = builder.uid;
        this.user = builder.user;
        this.gid = builder.gid;
        this.group = builder.group;
        this.mtime = builder.mtime;
        this.target = builder.target;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public OptionalLong getSize() {
        return this.size == null ? OptionalLong.empty() : OptionalLong.of(this.size);
    }

    public OptionalLong getUid() {
        return this.uid == null ? OptionalLong.empty() : OptionalLong.of(this.uid);
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public OptionalLong getGid() {
        return this.gid == null ? OptionalLong.empty() : OptionalLong.of(this.gid);
    }

    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    public Optional<String> getMtime() {
        return Optional.ofNullable(this.mtime);
    }

    public Optional<String> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public String toString() {
        return "UnixFile{name=" + this.name + ", mode=" + this.mode + ", size=" + this.size + ", uid=" + this.uid + ", user=" + this.user + ", gid=" + this.gid + ", group=" + this.group + ", mtime=" + this.mtime + ", target=" + this.target + "}";
    }

    public static class Builder {
        private String name;
        private String mode;
        private Long size;
        private Long uid;
        private String user;
        private Long gid;
        private String group;
        private String mtime;
        private String target;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder gid(Long gid) {
            this.gid = gid;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public UnixFile build() {
            return new UnixFile(this);
        }
    }
}

