/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.jackson.JacksonElement;

class JacksonObject
extends JacksonElement<ObjectNode>
implements JsonEngine.Object {
    public JacksonObject(ObjectNode element) {
        super(element);
    }

    @Override
    public int size() {
        return ((ObjectNode)this.element).size();
    }

    @Override
    public boolean has(String key) {
        return ((ObjectNode)this.element).has(key);
    }

    @Override
    public JsonEngine.Element get(String key) {
        return JacksonObject.wrap(((ObjectNode)this.element).get(key));
    }

    @Override
    public void add(String key, JsonEngine.Element value) {
        ((ObjectNode)this.element).set(key, (JsonNode)value.getEngineElement());
    }

    @Override
    public void addProperty(String key, Boolean value) {
        ((ObjectNode)this.element).put(key, value);
    }

    @Override
    public void addProperty(String key, String value) {
        ((ObjectNode)this.element).put(key, value);
    }

    @Override
    public void addProperty(String key, Number number) {
        if (number instanceof Integer) {
            ((ObjectNode)this.element).put(key, (Integer)number);
        } else if (number instanceof Double) {
            ((ObjectNode)this.element).put(key, (Double)number);
        } else if (number instanceof BigInteger) {
            ((ObjectNode)this.element).put(key, (BigInteger)number);
        } else if (number instanceof Float) {
            ((ObjectNode)this.element).put(key, (Float)number);
        } else if (number instanceof BigDecimal) {
            ((ObjectNode)this.element).put(key, (BigDecimal)number);
        } else if (number instanceof Long) {
            ((ObjectNode)this.element).put(key, (Long)number);
        }
    }

    @Override
    public void addProperty(String key, JsonEngine.Element value) {
        ((ObjectNode)this.element).set(key, (JsonNode)value.getEngineElement());
    }

    @Override
    public void remove(String key) {
        ((ObjectNode)this.element).remove(key);
    }

    @Override
    public <E extends Enum> void add(String key, E enumValue) {
        if (enumValue == null) {
            ((ObjectNode)this.element).set(key, NullNode.getInstance());
        } else {
            ((ObjectNode)this.element).put(key, enumValue.name());
        }
    }

    @Override
    public Set<String> keySet() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((ObjectNode)this.element).fieldNames(), 16), false).collect(Collectors.toSet());
    }
}

