/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import java.util.concurrent.atomic.AtomicInteger;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.exception.ZosmfRequestException;

public class ResponseUtil {
    private ResponseUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getResponseStr(ZosmfRequest request) throws ZosmfRequestException {
        Response response = request.executeRequest();
        String responseStr = response.getResponsePhrase().orElseThrow(() -> new ZosmfRequestException("response phrase is either null or empty")).toString();
        AtomicInteger statusCode = new AtomicInteger();
        response.getStatusCode().ifPresent(statusCode::set);
        if (statusCode.get() < 100 || statusCode.get() > 299) {
            throw new ZosmfRequestException("Response: " + responseStr);
        }
        return responseStr;
    }
}

