/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.model;

import java.util.Optional;
import java.util.OptionalLong;

public class UnixZfs {
    private final String name;
    private final String mountpoint;
    private final String fstname;
    private final String status;
    private final String mode;
    private final Long dev;
    private final Long fstype;
    private final Long bsize;
    private final Long bavail;
    private final Long blocks;
    private final String sysname;
    public final Long readibc;
    public final Long writeibc;
    private final Long diribc;
    private final Long returnedRows;
    private final Long totalRows;
    private final boolean moreRows;

    public UnixZfs(Builder builder) {
        this.name = builder.name;
        this.mountpoint = builder.mountpoint;
        this.fstname = builder.fstname;
        this.status = builder.status;
        this.mode = builder.mode;
        this.dev = builder.dev;
        this.fstype = builder.fstype;
        this.bsize = builder.bsize;
        this.bavail = builder.bavail;
        this.blocks = builder.blocks;
        this.sysname = builder.sysname;
        this.readibc = builder.readibc;
        this.writeibc = builder.writeibc;
        this.diribc = builder.diribc;
        this.returnedRows = builder.returnedRows;
        this.totalRows = builder.totalRows;
        this.moreRows = builder.moreRows;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getMountpoint() {
        return Optional.ofNullable(this.mountpoint);
    }

    public Optional<String> getFstname() {
        return Optional.ofNullable(this.fstname);
    }

    public Optional<String> getStatus() {
        return Optional.ofNullable(this.status);
    }

    public Optional<String> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public OptionalLong getDev() {
        return this.dev == null ? OptionalLong.empty() : OptionalLong.of(this.dev);
    }

    public OptionalLong getFstype() {
        return this.fstype == null ? OptionalLong.empty() : OptionalLong.of(this.fstype);
    }

    public OptionalLong getBsize() {
        return this.bsize == null ? OptionalLong.empty() : OptionalLong.of(this.bsize);
    }

    public OptionalLong getBavail() {
        return this.bavail == null ? OptionalLong.empty() : OptionalLong.of(this.bavail);
    }

    public OptionalLong getBlocks() {
        return this.blocks == null ? OptionalLong.empty() : OptionalLong.of(this.blocks);
    }

    public Optional<String> getSysname() {
        return Optional.ofNullable(this.sysname);
    }

    public OptionalLong getReadibc() {
        return this.readibc == null ? OptionalLong.empty() : OptionalLong.of(this.readibc);
    }

    public OptionalLong getWriteibc() {
        return this.writeibc == null ? OptionalLong.empty() : OptionalLong.of(this.writeibc);
    }

    public OptionalLong getDiribc() {
        return this.diribc == null ? OptionalLong.empty() : OptionalLong.of(this.diribc);
    }

    public OptionalLong getReturnedRows() {
        return this.returnedRows == null ? OptionalLong.empty() : OptionalLong.of(this.returnedRows);
    }

    public OptionalLong getTotalRows() {
        return this.totalRows == null ? OptionalLong.empty() : OptionalLong.of(this.totalRows);
    }

    public boolean isMoreRows() {
        return this.moreRows;
    }

    public String toString() {
        return "UnixZfs{name=" + this.name + ", mountpoint=" + this.mountpoint + ", fstname=" + this.fstname + ", status=" + this.status + ", mode=" + this.mode + ", dev=" + this.dev + ", fstype=" + this.fstype + ", bsize=" + this.bsize + ", bavail=" + this.bavail + ", blocks=" + this.blocks + ", sysname=" + this.sysname + ", readibc=" + this.readibc + ", writeibc=" + this.writeibc + ", diribc=" + this.diribc + ", returnedRows=" + this.returnedRows + ", totalRows=" + this.totalRows + ", moreRows=" + this.moreRows + "}";
    }

    public static class Builder {
        private String name;
        private String mountpoint;
        private String fstname;
        private String status;
        private String mode;
        private Long dev;
        private Long fstype;
        private Long bsize;
        private Long bavail;
        private Long blocks;
        private String sysname;
        private Long readibc;
        private Long writeibc;
        private Long diribc;
        private Long returnedRows;
        private Long totalRows;
        private boolean moreRows = false;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mountpoint(String mountpoint) {
            this.mountpoint = mountpoint;
            return this;
        }

        public Builder fstname(String fstname) {
            this.fstname = fstname;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder dev(Long dev) {
            this.dev = dev;
            return this;
        }

        public Builder fstype(Long fstype) {
            this.fstype = fstype;
            return this;
        }

        public Builder bsize(Long bsize) {
            this.bsize = bsize;
            return this;
        }

        public Builder bavail(Long bavail) {
            this.bavail = bavail;
            return this;
        }

        public Builder blocks(Long blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder sysname(String sysname) {
            this.sysname = sysname;
            return this;
        }

        public Builder readibc(Long readibc) {
            this.readibc = readibc;
            return this;
        }

        public Builder writeibc(Long writeibc) {
            this.writeibc = writeibc;
            return this;
        }

        public Builder diribc(Long diribc) {
            this.diribc = diribc;
            return this;
        }

        public Builder returnedRows(Long returnedRows) {
            this.returnedRows = returnedRows;
            return this;
        }

        public Builder totalRows(Long totalRows) {
            this.totalRows = totalRows;
            return this;
        }

        public Builder moreRows(boolean moreRows) {
            this.moreRows = moreRows;
            return this;
        }

        public UnixZfs build() {
            return new UnixZfs(this);
        }
    }
}

