/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.input;

import java.util.Optional;
import zowe.client.sdk.zoslogs.types.DirectionType;
import zowe.client.sdk.zoslogs.types.HardCopyType;

public class ZosLogInputData {
    private final String startTime;
    private final HardCopyType hardCopy;
    private final DirectionType direction;
    private final String timeRange;
    private final boolean processResponses;
    private final int queryCount;

    private ZosLogInputData(Builder builder) {
        this.startTime = builder.startTime;
        this.hardCopy = builder.hardCopy;
        this.direction = builder.direction;
        this.timeRange = builder.timeRange;
        this.processResponses = builder.processResponses;
        this.queryCount = builder.queryCount;
    }

    public Optional<String> getStartTime() {
        return Optional.ofNullable(this.startTime);
    }

    public Optional<HardCopyType> getHardCopy() {
        return Optional.ofNullable(this.hardCopy);
    }

    public Optional<DirectionType> getDirection() {
        return Optional.ofNullable(this.direction);
    }

    public Optional<String> getTimeRange() {
        return Optional.ofNullable(this.timeRange);
    }

    public boolean isProcessResponses() {
        return this.processResponses;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public String toString() {
        return "ZosLogInputData{startTime=" + this.startTime + ", hardCopy=" + this.hardCopy + ", direction=" + this.direction + ", timeRange=" + this.timeRange + ", processResponses=" + this.processResponses + "}";
    }

    public static class Builder {
        private String startTime;
        private HardCopyType hardCopy;
        private DirectionType direction;
        private String timeRange;
        private boolean processResponses;
        private int queryCount = 0;

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            ++this.queryCount;
            return this;
        }

        public Builder hardCopy(HardCopyType hardCopy) {
            this.hardCopy = hardCopy;
            ++this.queryCount;
            return this;
        }

        public Builder direction(DirectionType direction) {
            this.direction = direction;
            ++this.queryCount;
            return this;
        }

        public Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            ++this.queryCount;
            return this;
        }

        public Builder processResponses(boolean processResponses) {
            this.processResponses = processResponses;
            ++this.queryCount;
            return this;
        }

        public ZosLogInputData build() {
            return new ZosLogInputData(this);
        }
    }
}

