/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.DsnCopyInputData;

public class DsnCopy {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnCopy(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    DsnCopy(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response copy(String fromDataSetName, String toDataSetName, boolean replace, boolean copyAllMembers) throws ZosmfRequestException {
        return this.copyCommon(new DsnCopyInputData.Builder().fromDataSet(fromDataSetName).toDataSet(toDataSetName).replace(replace).copyAllMembers(copyAllMembers).build());
    }

    public Response copyCommon(DsnCopyInputData copyInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(copyInputData == null, "copyInputData is null");
        String url = this.setUrl(copyInputData);
        Map<String, Object> fromDataSetMap = this.setFromDataSetMapValues(copyInputData);
        HashMap<String, Object> copyMap = new HashMap<String, Object>();
        copyMap.put("request", "copy");
        copyMap.put("from-dataset", new JSONObject(fromDataSetMap));
        copyMap.put("replace", copyInputData.isReplace());
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(copyMap).toString());
        return this.request.executeRequest();
    }

    private String setUrl(DsnCopyInputData copyInputData) {
        String toDataSetNameErrMsg = "toDataSetName not specified";
        String toDataSet = copyInputData.getToDataSet().orElseThrow(() -> new IllegalArgumentException("toDataSetName not specified"));
        String url = this.connection.getZosmfUrl() + "/restfiles/ds/";
        if (copyInputData.getToVolser().isPresent()) {
            url = url + "-(" + copyInputData.getToVolser().get() + ")/";
        }
        url = url + EncodeUtils.encodeURIComponent(toDataSet);
        return url;
    }

    private Map<String, Object> setFromDataSetMapValues(DsnCopyInputData copyInputData) {
        String fromDataSetNameErrMsg = "fromDataSetName not specified";
        String fromDataSetName = copyInputData.getFromDataSet().orElseThrow(() -> new IllegalStateException("fromDataSetName not specified"));
        HashMap<String, Object> fromDataSetReq = new HashMap<String, Object>();
        if (this.isMemberNameIncluded(fromDataSetName)) {
            int startMemberIndex = fromDataSetName.indexOf("(");
            String member = fromDataSetName.substring(startMemberIndex + 1, fromDataSetName.length() - 1);
            fromDataSetReq.put("member", member);
            fromDataSetName = fromDataSetName.substring(0, startMemberIndex);
        } else if (copyInputData.isCopyAllMembers()) {
            fromDataSetReq.put("member", "*");
        }
        fromDataSetReq.put("dsn", fromDataSetName);
        if (copyInputData.getFromVolser().isPresent()) {
            fromDataSetReq.put("volser", copyInputData.getFromVolser().get());
        }
        return fromDataSetReq;
    }

    private boolean isMemberNameIncluded(String fromDataSetName) {
        return fromDataSetName.indexOf("(") > 0;
    }
}

