/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutTextZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnWrite {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnWrite(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    DsnWrite(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutTextZosmfRequest)) {
            throw new IllegalStateException("PUT_TEXT request type required");
        }
        this.request = request;
    }

    public Response write(String dataSetName, String memberName, String content) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(dataSetName, "dataSetName");
        ValidateUtils.checkIllegalParameter(memberName, "memberName");
        return this.write(String.format("%s(%s)", dataSetName, memberName), content);
    }

    public Response write(String dataSetName, String content) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(dataSetName, "dataSetName");
        ValidateUtils.checkIllegalParameter(content, "content");
        String url = this.connection.getZosmfUrl() + "/restfiles/ds/" + EncodeUtils.encodeURIComponent(dataSetName);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_TEXT);
        }
        this.request.setUrl(url);
        this.request.setBody(content);
        return this.request.executeRequest();
    }
}

