/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.UssCreateInputData;
import zowe.client.sdk.zosfiles.uss.input.UssCreateZfsInputData;

public class UssCreate {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssCreate(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssCreate(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PostJsonZosmfRequest)) {
            throw new IllegalStateException("POST_JSON request type required");
        }
        this.request = request;
    }

    public Response create(String targetPath, UssCreateInputData createInputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(targetPath, "targetPath");
        ValidateUtils.checkNullParameter(createInputData == null, "createInputData is null");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        HashMap<String, String> createMap = new HashMap<String, String>();
        createMap.put("type", createInputData.getType().getValue());
        createMap.put("mode", createInputData.getMode());
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(createMap).toString());
        return this.request.executeRequest();
    }

    public Response createZfs(String fileSystemName) throws ZosmfRequestException {
        return this.createZfsCommon(fileSystemName, new UssCreateZfsInputData.Builder(10).cylsSec(2).timeout(20).build());
    }

    public Response createZfsCommon(String fileSystemName, UssCreateZfsInputData createZfsInputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fileSystemName, "fileSystemName");
        ValidateUtils.checkNullParameter(createZfsInputData == null, "createZfsInputData is null");
        StringBuilder url = new StringBuilder(this.connection.getZosmfUrl() + "/restfiles/mfs/zfs/" + EncodeUtils.encodeURIComponent(fileSystemName));
        createZfsInputData.getTimeout().ifPresent(timeout -> url.append("?timeout=").append(timeout));
        HashMap<String, Object> createZfsMap = new HashMap<String, Object>();
        createZfsInputData.getOwner().ifPresent(owner -> createZfsMap.put("owner", owner));
        createZfsInputData.getGroup().ifPresent(group -> createZfsMap.put("group", group));
        createZfsInputData.getPerms().ifPresent(perms -> createZfsMap.put("perms", perms));
        createZfsInputData.getCylsPri().ifPresent(cylsPri -> createZfsMap.put("cylsPri", cylsPri));
        createZfsInputData.getCylsSec().ifPresent(cs -> createZfsMap.put("cylsSec", cs));
        createZfsInputData.getStorageClass().ifPresent(sc -> createZfsMap.put("storageClass", sc));
        createZfsInputData.getManagementClass().ifPresent(mc -> createZfsMap.put("managementClass", mc));
        createZfsInputData.getDataClass().ifPresent(dc -> createZfsMap.put("dataClass", dc));
        if (createZfsInputData.getVolumes().size() == 1) {
            createZfsMap.put("volumes", "[\"" + createZfsInputData.getVolumes().get(0) + "\"]");
        }
        if (createZfsInputData.getVolumes().size() > 1) {
            StringBuilder volumesStr = new StringBuilder();
            createZfsInputData.getVolumes().forEach(volume -> volumesStr.append("\"").append((String)volume).append("\","));
            createZfsMap.put("volumes", "[" + volumesStr.substring(0, volumesStr.length() - 1) + "]");
        }
        createZfsMap.put("JSONversion", 1);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        createZfsInputData.getSystem().ifPresent(system -> headers.put("X-IBM-Target-System", (String)system));
        this.request.setHeaders(headers);
        this.request.setUrl(url.toString());
        this.request.setBody(new JSONObject(createZfsMap).toString());
        return this.request.executeRequest();
    }
}

