/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.methods;

import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.TsoUtil;
import zowe.client.sdk.utility.ValidateUtils;

public class TsoReply {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public TsoReply(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    TsoReply(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public String reply(String sessionId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(sessionId, "sessionId");
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + sessionId;
        if (this.request == null || !(this.request instanceof PutJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        return TsoUtil.getResponseStr(this.request);
    }
}

