/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.methods;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.TsoUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.response.TsoCommonResponse;

public class TsoStop {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public TsoStop(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    TsoStop(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public TsoCommonResponse stop(String sessionId) throws ZosmfRequestException {
        TsoCommonResponse tsoCommonResponse;
        ValidateUtils.checkIllegalParameter(sessionId, "sessionId");
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + sessionId;
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        String responseStr = TsoUtil.getResponseStr(this.request);
        try {
            tsoCommonResponse = this.objectMapper.readValue(responseStr, TsoCommonResponse.class);
        }
        catch (JsonProcessingException e) {
            String errMsg = TsoUtil.getMsgDataText(responseStr);
            throw new ZosmfRequestException(errMsg.isBlank() ? e.getMessage() : errMsg);
        }
        return tsoCommonResponse;
    }
}

