/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.altzostso.method;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import zowe.client.sdk.altzostso.input.StartTsoInputData;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;

public class IssueTso {
    private final List<String> msgLst = new ArrayList<String>();
    private final List<String> promptLst = new ArrayList<String>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ZosConnection connection;
    private final String accountNumber;
    private ZosmfRequest request;
    private StartTsoInputData startTsoData;

    public IssueTso(ZosConnection connection, String accountNumber) {
        this.connection = connection;
        this.accountNumber = accountNumber;
    }

    public List<String> issueCommend(String command) throws ZosmfRequestException {
        return this.issueCommend(command, null);
    }

    public List<String> issueCommend(String command, StartTsoInputData startTsoData) throws ZosmfRequestException {
        this.startTsoData = startTsoData;
        String sessionKey = this.startTso();
        return this.processTsoCommand(sessionKey, command);
    }

    private List<String> processTsoCommand(String sessionKey, String command) throws ZosmfRequestException {
        this.msgLst.clear();
        this.promptLst.clear();
        String responseStr = this.sendTsoCommand(sessionKey, command);
        JsonNode tsoData = this.getJsonNode(responseStr, "Failed to sendTsoCommand session for initial tso command execution.").get("tsoData");
        this.processTsoData(tsoData);
        while (this.promptLst.isEmpty()) {
            responseStr = this.sendTso(sessionKey);
            tsoData = this.getJsonNode(responseStr, "Failed to sendTso session ping for more data.").get("tsoData");
            this.processTsoData(tsoData);
        }
        this.stopTso(sessionKey);
        return this.msgLst;
    }

    private String startTso() throws ZosmfRequestException {
        if (this.startTsoData == null) {
            this.startTsoData = new StartTsoInputData();
        }
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso?acct=" + EncodeUtils.encodeURIComponent(this.accountNumber) + "&proc=" + this.startTsoData.getLogonProcedure().orElse("IZUFPROC") + "&chset=" + this.startTsoData.getCharacterSet().orElse("697") + "&cpage=" + this.startTsoData.getCodePage().orElse("1047") + "&rows=" + this.startTsoData.getRows().orElse("24") + "&cols=" + this.startTsoData.getColumns().orElse("80") + "&rsize=" + this.startTsoData.getRegionSize().orElse("4096");
        if (this.request == null || !(this.request instanceof PostJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        String responseStr = this.executeRequest(this.request, "Failed to startTso session.");
        JsonNode rootNode = this.getJsonNode(responseStr, "Failed to startTso session.");
        String servletKey = rootNode.get("servletKey").asText();
        if ("null".equalsIgnoreCase(servletKey)) {
            throw new ZosmfRequestException("Failed to startTso session. Response: " + responseStr);
        }
        return servletKey;
    }

    private String sendTsoCommand(String sessionKey, String command) throws ZosmfRequestException {
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + sessionKey + "?readReply=false";
        String body = "{\"TSO RESPONSE\":{\"VERSION\":\"0100\",\"DATA\":\"" + command + "\"}}";
        if (this.request == null || !(this.request instanceof PutJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(body);
        return this.executeRequest(this.request, "Failed to sendTsoCommand session for initial tso command execution.");
    }

    private String sendTso(String sessionKey) throws ZosmfRequestException {
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + sessionKey;
        if (this.request == null || !(this.request instanceof PutJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        return this.executeRequest(this.request, "Failed to sendTso session ping for more data.");
    }

    private void stopTso(String sessionKey) throws ZosmfRequestException {
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + sessionKey;
        if (this.request == null || !(this.request instanceof DeleteJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        this.executeRequest(this.request, "Failed to stopTso session.");
    }

    private void processTsoData(JsonNode tsoData) {
        tsoData.forEach(tsoDataItem -> {
            try {
                if (tsoDataItem.get("TSO MESSAGE") != null) {
                    this.msgLst.add(tsoDataItem.get("TSO MESSAGE").get("DATA").asText());
                }
                if (tsoDataItem.get("TSO PROMPT") != null) {
                    this.promptLst.add(tsoDataItem.get("TSO PROMPT").get("HIDDEN").asText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private String executeRequest(ZosmfRequest request, String msg) throws ZosmfRequestException {
        Response response = request.executeRequest();
        String responseStr = response.getResponsePhrase().orElse("").toString();
        if ("".equals(responseStr)) {
            throw new ZosmfRequestException(msg + " Response: " + responseStr);
        }
        AtomicInteger statusCode = new AtomicInteger();
        response.getStatusCode().ifPresent(statusCode::set);
        if (statusCode.get() < 100 || statusCode.get() > 299) {
            throw new ZosmfRequestException(msg + " Response: " + responseStr);
        }
        return responseStr;
    }

    private JsonNode getJsonNode(String responseStr, String msg) throws ZosmfRequestException {
        JsonNode rootNode;
        try {
            rootNode = this.objectMapper.readTree(responseStr);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException(msg + " Response: " + e.getMessage());
        }
        return rootNode;
    }
}

