/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.MountActionType;
import zowe.client.sdk.zosfiles.uss.types.MountModeType;

public class UssMountInputData {
    private final MountActionType action;
    private final String mountPoint;
    private final String fsType;
    private final MountModeType mode;

    public UssMountInputData(Builder builder) {
        this.action = builder.action;
        this.mountPoint = builder.mountPoint;
        this.fsType = builder.fsType;
        this.mode = builder.mode;
    }

    public Optional<MountActionType> getAction() {
        return Optional.ofNullable(this.action);
    }

    public Optional<String> getMountPoint() {
        return Optional.ofNullable(this.mountPoint);
    }

    public Optional<String> getFsType() {
        return Optional.ofNullable(this.fsType);
    }

    public Optional<MountModeType> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public String toString() {
        return "UssMountInputData{action=" + this.action + ", mountPoint=" + this.mountPoint + ", fsType=" + this.fsType + ", mode=" + this.mode + "}";
    }

    public static class Builder {
        private MountActionType action;
        private String mountPoint;
        private String fsType;
        private MountModeType mode;

        public Builder action(MountActionType action) {
            this.action = action;
            return this;
        }

        public Builder mountPoint(String mountPoint) {
            ValidateUtils.checkNullParameter(mountPoint == null, "mountPoint is null");
            ValidateUtils.checkIllegalParameter(mountPoint.isBlank(), "mountPoint not specified");
            this.mountPoint = mountPoint;
            return this;
        }

        public Builder fsType(String fsType) {
            ValidateUtils.checkNullParameter(fsType == null, "fsType is null");
            ValidateUtils.checkIllegalParameter(fsType.isBlank(), "fsType not specified");
            this.fsType = fsType;
            return this;
        }

        public Builder mode(MountModeType mode) {
            this.mode = mode;
            return this;
        }

        public UssMountInputData build() {
            return new UssMountInputData(this);
        }
    }
}

