/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.GetTextZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.JsonParserUtil;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.CommonJobInputData;
import zowe.client.sdk.zosjobs.input.JobGetInputData;
import zowe.client.sdk.zosjobs.response.Job;
import zowe.client.sdk.zosjobs.response.JobFile;

public class JobGet {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private String url;

    public JobGet(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    JobGet(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        this.request = request;
        if (!(request instanceof GetJsonZosmfRequest) && !(request instanceof GetTextZosmfRequest)) {
            throw new IllegalStateException("GET_JSON or GET_TEXT request type required");
        }
    }

    public String getJcl(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.getJclCommon(new CommonJobInputData(jobId, jobName));
    }

    public String getJclByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getJclCommon(new CommonJobInputData(job.getJobId().orElse(""), job.getJobName().orElse("")));
    }

    public String getJclCommon(CommonJobInputData params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files/JCL/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job jcl response phrase"));
    }

    public Job getById(String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        List<Job> jobs = this.getCommon(new JobGetInputData.Builder("*").jobId(jobId).build());
        if (jobs.isEmpty()) {
            throw new IllegalStateException("job not found");
        }
        if (jobs.size() > 1) {
            throw new IllegalStateException("expected 1 job returned but received " + jobs.size() + " jobs.");
        }
        return jobs.get(0);
    }

    public List<Job> getAll() throws ZosmfRequestException {
        return this.getCommon(null);
    }

    public List<Job> getByOwner(String owner) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(owner, "owner");
        return this.getCommon(new JobGetInputData.Builder(owner).build());
    }

    public List<Job> getByOwnerAndPrefix(String owner, String prefix) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(owner, "owner");
        ValidateUtils.checkIllegalParameter(prefix, "prefix");
        return this.getCommon(new JobGetInputData.Builder(owner).prefix(prefix).build());
    }

    public List<Job> getByPrefix(String prefix) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(prefix, "prefix");
        return this.getCommon(new JobGetInputData.Builder("*").prefix(prefix).build());
    }

    public List<Job> getCommon(JobGetInputData params) throws ZosmfRequestException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs?";
        if (params != null) {
            if (params.getOwner().isPresent()) {
                this.url = this.url + "owner=" + params.getOwner().get();
            }
            if (params.getPrefix().isPresent() && !"*".equals(params.getPrefix().get())) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "prefix=" + EncodeUtils.encodeURIComponent(params.getPrefix().get());
            }
            if (params.getMaxJobs().isPresent() && params.getMaxJobs().getAsInt() != 1000) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "max-jobs=" + params.getMaxJobs().getAsInt();
            }
            if (params.getJobId().isPresent()) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "jobid=" + params.getJobId().get();
            }
        } else if (this.connection.getUser() != null && !this.connection.getUser().isEmpty()) {
            this.url = this.url + "owner=" + this.connection.getUser();
        }
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no get job response phrase")).toString();
        JSONArray results = JsonParserUtil.parseArray(jsonStr);
        for (Object jsonObj : results) {
            jobs.add((Job)JsonParseFactory.buildParser(ParseType.JOB).parseResponse(jsonObj));
        }
        return jobs;
    }

    public String getSpoolContent(JobFile jobFile) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        return this.getSpoolContentCommon(jobFile);
    }

    public String getSpoolContent(String jobName, String jobId, int spoolId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        ValidateUtils.checkIllegalParameter(spoolId <= 0, "spool id not specified");
        CommonJobInputData params = new CommonJobInputData(jobId, jobName);
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files/" + spoolId + "/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        String spoolErrMsg = "no job spool content response phrase";
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job spool content response phrase"));
    }

    public String getSpoolContentCommon(JobFile jobFile) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        if (jobFile.getJobName().isEmpty() || jobFile.getJobId().isEmpty() || jobFile.getId().isEmpty()) {
            throw new ZosmfRequestException("jobFileName, JobId or jobFileId is either null or empty");
        }
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(jobFile.getJobName().get()) + "/" + jobFile.getJobId().get() + "/files/" + jobFile.getId().getAsLong() + "/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        String spoolErrMsg = "no job spool file content response phrase";
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job spool file content response phrase"));
    }

    public List<JobFile> getSpoolFiles(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.getSpoolFilesCommon(new CommonJobInputData(jobId, jobName));
    }

    public List<JobFile> getSpoolFilesCommon(CommonJobInputData params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get() + "/files";
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        ArrayList<JobFile> files = new ArrayList<JobFile>();
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElse("").toString();
        if (jsonStr.isBlank()) {
            return files;
        }
        JSONArray results = JsonParserUtil.parseArray(jsonStr);
        for (Object obj : results) {
            JSONObject jsonObj = (JSONObject)obj;
            files.add((JobFile)JsonParseFactory.buildParser(ParseType.JOB_FILE).parseResponse(jsonObj));
        }
        return files;
    }

    public List<JobFile> getSpoolFilesByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getSpoolFilesCommon(new CommonJobInputData(job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty")), job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty"))));
    }

    public Job getStatus(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.getStatusCommon(new CommonJobInputData(jobId, jobName, true));
    }

    public Job getStatusCommon(CommonJobInputData params) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(params == null, "params is null");
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(params.getJobName().get()) + "/" + params.getJobId().get();
        if (params.isStepData()) {
            this.url = this.url + "?step-data=Y";
        }
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job get response phrase")).toString();
        JSONObject jsonObject = JsonParserUtil.parse(jsonStr);
        return (Job)JsonParseFactory.buildParser(ParseType.JOB).parseResponse(jsonObject);
    }

    public Job getStatusByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getStatusCommon(new CommonJobInputData(job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty")), job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty")), true));
    }

    public String getStatusValue(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        Job job = this.getStatusCommon(new CommonJobInputData(jobId, jobName));
        return job.getStatus().orElseThrow(() -> new IllegalStateException("job status not returned"));
    }

    public String getStatusValueByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        Job result = this.getStatusCommon(new CommonJobInputData(job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty")), job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty"))));
        return result.getStatus().orElseThrow(() -> new IllegalStateException("job status not returned"));
    }

    public String getUrl() {
        return this.url;
    }
}

