/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.response;

import java.util.Optional;
import java.util.OptionalLong;

public class JobFile {
    private final String jobId;
    private final String jobName;
    private final String recfm;
    private final Long byteCount;
    private final Long recordCount;
    private final String jobCorrelator;
    private final String classs;
    private final Long id;
    private final String ddName;
    private final String recordsUrl;
    private final Long lrecl;
    private final String subSystem;
    private final String stepName;
    private final String procStep;

    private JobFile(Builder builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.recfm = builder.recfm;
        this.byteCount = builder.byteCount;
        this.recordCount = builder.recordCount;
        this.jobCorrelator = builder.jobCorrelator;
        this.classs = builder.classs;
        this.id = builder.id;
        this.ddName = builder.ddName;
        this.recordsUrl = builder.recordsUrl;
        this.lrecl = builder.lrecl;
        this.subSystem = builder.subSystem;
        this.stepName = builder.stepName;
        this.procStep = builder.procStep;
    }

    public OptionalLong getByteCount() {
        return this.byteCount == null ? OptionalLong.empty() : OptionalLong.of(this.byteCount);
    }

    public Optional<String> getClasss() {
        return Optional.ofNullable(this.classs);
    }

    public Optional<String> getDdName() {
        return Optional.ofNullable(this.ddName);
    }

    public OptionalLong getId() {
        return this.id == null ? OptionalLong.empty() : OptionalLong.of(this.id);
    }

    public Optional<String> getJobCorrelator() {
        return Optional.ofNullable(this.jobCorrelator);
    }

    public Optional<String> getJobId() {
        return Optional.ofNullable(this.jobId);
    }

    public Optional<String> getJobName() {
        return Optional.ofNullable(this.jobName);
    }

    public OptionalLong getLrecl() {
        return this.lrecl == null ? OptionalLong.empty() : OptionalLong.of(this.lrecl);
    }

    public Optional<String> getProcStep() {
        return Optional.ofNullable(this.procStep);
    }

    public Optional<String> getRecfm() {
        return Optional.ofNullable(this.recfm);
    }

    public OptionalLong getRecordCount() {
        return this.recordCount == null ? OptionalLong.empty() : OptionalLong.of(this.recordCount);
    }

    public Optional<String> getRecordsUrl() {
        return Optional.ofNullable(this.recordsUrl);
    }

    public Optional<String> getStepName() {
        return Optional.ofNullable(this.stepName);
    }

    public Optional<String> getSubSystem() {
        return Optional.ofNullable(this.subSystem);
    }

    public String toString() {
        return "JobFile{jobId=" + this.jobId + ", jobName=" + this.jobName + ", recfm=" + this.recfm + ", byteCount=" + this.byteCount + ", recordCount=" + this.recordCount + ", jobCorrelator=" + this.jobCorrelator + ", classs=" + this.classs + ", id=" + this.id + ", ddName=" + this.ddName + ", recordsUrl=" + this.recordsUrl + ", lrecl=" + this.lrecl + ", subSystem=" + this.subSystem + ", stepName=" + this.stepName + ", procStep=" + this.procStep + "}";
    }

    public static class Builder {
        private String jobId;
        private String jobName;
        private String recfm;
        private Long byteCount;
        private Long recordCount;
        private String jobCorrelator;
        private String classs;
        private Long id;
        private String ddName;
        private String recordsUrl;
        private Long lrecl;
        private String subSystem;
        private String stepName;
        private String procStep;

        public Builder byteCount(Long byteCount) {
            this.byteCount = byteCount;
            return this;
        }

        public Builder classs(String classs) {
            this.classs = classs;
            return this;
        }

        public Builder ddName(String ddName) {
            this.ddName = ddName;
            return this;
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder jobCorrelator(String jobCorrelator) {
            this.jobCorrelator = jobCorrelator;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder lrecl(Long lrecl) {
            this.lrecl = lrecl;
            return this;
        }

        public Builder procStep(String procStep) {
            this.procStep = procStep;
            return this;
        }

        public Builder recfm(String recfm) {
            this.recfm = recfm;
            return this;
        }

        public Builder recordCount(Long recordCount) {
            this.recordCount = recordCount;
            return this;
        }

        public Builder recordsUrl(String recordsUrl) {
            this.recordsUrl = recordsUrl;
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public Builder subSystem(String subSystem) {
            this.subSystem = subSystem;
            return this;
        }

        public JobFile build() {
            return new JobFile(this);
        }
    }
}

