/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetStreamZosmfRequest;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.dsn.input.DsnDownloadInputData;
import zowe.client.sdk.zosfiles.dsn.input.DsnListInputData;
import zowe.client.sdk.zosfiles.dsn.methods.DsnList;
import zowe.client.sdk.zosfiles.dsn.response.Dataset;
import zowe.client.sdk.zosfiles.dsn.types.AttributeType;

public class DsnGet {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public DsnGet(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    DsnGet(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetStreamZosmfRequest)) {
            throw new IllegalStateException("GET_STREAM request type required");
        }
        this.request = request;
    }

    public Dataset getDsnInfo(String dataSetName) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(dataSetName == null, "dataSetName is null");
        ValidateUtils.checkIllegalParameter(dataSetName.isBlank(), "dataSetName not specified");
        Dataset emptyDataSet = new Dataset.Builder().dsname(dataSetName).build();
        String[] tokens = dataSetName.split("\\.");
        int length = tokens.length - 1;
        if (1 >= length) {
            return emptyDataSet;
        }
        StringBuilder str = new StringBuilder();
        IntStream.range(0, length).forEach(i -> str.append(tokens[i]).append("."));
        String dataSetSearchStr = str.toString();
        dataSetSearchStr = dataSetSearchStr.substring(0, str.length() - 1);
        DsnList dsnList = new DsnList(this.connection);
        DsnListInputData params = new DsnListInputData.Builder().attribute(AttributeType.BASE).build();
        List<Dataset> dsLst = dsnList.getDatasets(dataSetSearchStr, params);
        Optional<Dataset> dataSet = dsLst.stream().filter(d -> d.getDsname().orElse("n/a").contains(dataSetName)).findFirst();
        return dataSet.orElse(emptyDataSet);
    }

    public InputStream get(String targetName, DsnDownloadInputData params) throws ZosmfRequestException {
        Object value;
        String key;
        ValidateUtils.checkIllegalParameter(targetName, "targetName");
        ValidateUtils.checkNullParameter(params == null, "params is null");
        String url = this.connection.getZosmfUrl() + "/restfiles/ds/";
        if (params.getVolume().isPresent()) {
            url = url + "-(" + params.getVolume().get() + ")/";
        }
        url = url + EncodeUtils.encodeURIComponent(targetName);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (params.isBinary()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_BINARY").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_BINARY").get(1);
            headers.put(key, (String)value);
        } else if (params.getEncoding().isPresent()) {
            key = "X_IBM_TEXT";
            value = "X_IBM_TEXTX_IBM_TEXT_ENCODING" + params.getEncoding();
            headers.put(key, (String)value);
        }
        if (params.isReturnEtag()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(0);
            value = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RETURN_ETAG").get(1);
            headers.put(key, (String)value);
        }
        if (params.getResponseTimeout().isPresent()) {
            key = (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_RESPONSE_TIMEOUT").get(0);
            value = params.getResponseTimeout().get();
            headers.put(key, (String)value);
        }
        key = (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(0);
        value = params.getEncoding().isPresent() ? String.valueOf(params.getEncoding().getAsLong()) : (String)ZosmfHeaders.HEADERS.get((Object)"ACCEPT_ENCODING").get(1);
        headers.put(key, (String)value);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_STREAM);
        }
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return new ByteArrayInputStream((byte[])this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no dsn get response phrase")));
    }
}

