/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagAction;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagType;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class UssChangeTagInputData {
    private final ChangeTagAction action;
    private final ChangeTagType type;
    private final String codeset;
    private final boolean recursive;
    private final LinkType links;

    public UssChangeTagInputData(Builder builder) {
        this.action = builder.action;
        this.type = builder.type;
        this.codeset = builder.codeset;
        this.recursive = builder.recursive;
        this.links = builder.links;
    }

    public Optional<ChangeTagAction> getAction() {
        return Optional.ofNullable(this.action);
    }

    public Optional<ChangeTagType> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getCodeset() {
        return Optional.ofNullable(this.codeset);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Optional<LinkType> getLinks() {
        return Optional.ofNullable(this.links);
    }

    public String toString() {
        return "UssChangeTagInputData{action='" + this.action + "', type='" + this.type + "', codeset='" + this.codeset + "', recursive='" + this.recursive + "', links='" + this.links + "'}";
    }

    public static class Builder {
        private ChangeTagAction action;
        private ChangeTagType type;
        private String codeset;
        private boolean recursive = false;
        private LinkType links;

        public Builder action(ChangeTagAction action) {
            ValidateUtils.checkNullParameter(action == null, "action is null");
            this.action = action;
            return this;
        }

        public Builder type(ChangeTagType type) {
            this.type = type;
            return this;
        }

        public Builder codeset(String codeset) {
            this.codeset = codeset;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder links(LinkType links) {
            this.links = links;
            return this;
        }

        public UssChangeTagInputData build() {
            return new UssChangeTagInputData(this);
        }
    }
}

