/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.ListFilterType;

public class UssListInputData {
    private final String path;
    private final Integer maxLength;
    private final String group;
    private final String user;
    private final String mtime;
    private final Integer size;
    private final String name;
    private final String perm;
    private final ListFilterType type;
    private final Integer depth;
    public final boolean filesys;
    public final boolean symlinks;

    public UssListInputData(Builder builder) {
        this.path = builder.path;
        this.maxLength = builder.maxLength;
        this.group = builder.group;
        this.user = builder.user;
        this.mtime = builder.mtime;
        this.size = builder.size;
        this.name = builder.name;
        this.perm = builder.perm;
        this.type = builder.type;
        this.depth = builder.depth;
        this.filesys = builder.filesys;
        this.symlinks = builder.symlinks;
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public OptionalInt getMaxLength() {
        return this.maxLength == null ? OptionalInt.empty() : OptionalInt.of(this.maxLength);
    }

    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public Optional<String> getMtime() {
        return Optional.ofNullable(this.mtime);
    }

    public OptionalInt getSize() {
        return this.size == null ? OptionalInt.empty() : OptionalInt.of(this.size);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getPerm() {
        return Optional.ofNullable(this.perm);
    }

    public Optional<ListFilterType> getType() {
        return Optional.ofNullable(this.type);
    }

    public OptionalInt getDepth() {
        return this.depth == null ? OptionalInt.empty() : OptionalInt.of(this.depth);
    }

    public boolean isFilesys() {
        return this.filesys;
    }

    public boolean isSymlinks() {
        return this.symlinks;
    }

    public String toString() {
        return "UssListInputData{path=" + this.path + ", maxLength=" + this.maxLength + ", group=" + this.group + ", user=" + this.user + ", mtime=" + this.mtime + ", size=" + this.size + ", name=" + this.name + ", perm=" + this.perm + ", type=" + this.type + ", depth=" + this.depth + ", filesys=" + this.filesys + ", symlinks=" + this.symlinks + "}";
    }

    public static class Builder {
        private String path;
        private Integer maxLength;
        private String group;
        private String user;
        private String mtime;
        private Integer size;
        private String name;
        private String perm;
        private ListFilterType type;
        private Integer depth;
        private boolean filesys = false;
        private boolean symlinks = false;

        public Builder path(String path) {
            ValidateUtils.checkNullParameter(path == null, "path is null");
            ValidateUtils.checkIllegalParameter(path.isBlank(), "path not specified");
            this.path = path;
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder perm(String perm) {
            this.perm = perm;
            return this;
        }

        public Builder type(ListFilterType type) {
            this.type = type;
            return this;
        }

        public Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public Builder filesys(boolean filesys) {
            this.filesys = filesys;
            return this;
        }

        public Builder symlinks(boolean symlinks) {
            this.symlinks = symlinks;
            return this;
        }

        public UssListInputData build() {
            return new UssListInputData(this);
        }
    }
}

