/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;
import java.util.OptionalInt;

public class JobGetInputData {
    private final String owner;
    private final String prefix;
    private final Integer maxJobs;
    private final String jobId;

    private JobGetInputData(Builder builder) {
        this.owner = builder.owner;
        this.prefix = builder.prefix;
        this.maxJobs = builder.maxJobs;
        this.jobId = builder.jobId;
    }

    public Optional<String> getJobId() {
        return Optional.ofNullable(this.jobId);
    }

    public OptionalInt getMaxJobs() {
        return this.maxJobs == null ? OptionalInt.empty() : OptionalInt.of(this.maxJobs);
    }

    public Optional<String> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public String toString() {
        return "JobGetInputData{owner=" + this.owner + ", prefix=" + this.prefix + ", maxJobs=" + this.maxJobs + ", jobId=" + this.jobId + "}";
    }

    public static class Builder {
        private String owner = "*";
        private String prefix = "*";
        private Integer maxJobs = 1000;
        private String jobId;

        public Builder() {
        }

        public Builder(String owner) {
            this.owner = owner;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder maxJobs(Integer maxJobs) {
            this.maxJobs = maxJobs;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public JobGetInputData build() {
            return new JobGetInputData(this);
        }
    }
}

