/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.response;

import java.util.Optional;
import java.util.OptionalLong;

public class JobStepData {
    private final String smfid;
    private final String completion;
    private final boolean active;
    private final Long stepNumber;
    private final String procStepName;
    private final String stepName;
    private final String programName;

    private JobStepData(Builder builder) {
        this.smfid = builder.smfid;
        this.completion = builder.completion;
        this.active = builder.active;
        this.stepNumber = builder.stepNumber;
        this.procStepName = builder.procStepName;
        this.stepName = builder.stepName;
        this.programName = builder.programName;
    }

    public boolean isActive() {
        return this.active;
    }

    public Optional<String> getCompletion() {
        return Optional.ofNullable(this.completion);
    }

    public Optional<String> getProcStepName() {
        return Optional.ofNullable(this.procStepName);
    }

    public Optional<String> getProgramName() {
        return Optional.ofNullable(this.programName);
    }

    public Optional<String> getSmfid() {
        return Optional.ofNullable(this.smfid);
    }

    public Optional<String> getStepName() {
        return Optional.ofNullable(this.stepName);
    }

    public OptionalLong getStepNumber() {
        return this.stepNumber == null ? OptionalLong.empty() : OptionalLong.of(this.stepNumber);
    }

    public String toString() {
        return "JobStepData{smfid=" + this.smfid + ", completion=" + this.completion + ", active=" + this.active + ", stepNumber=" + this.stepNumber + ", procStepName=" + this.procStepName + ", stepName=" + this.stepName + ", programName=" + this.programName + "}";
    }

    public static class Builder {
        private String smfid;
        private String completion;
        private boolean active;
        private Long stepNumber;
        private String procStepName;
        private String stepName;
        private String programName;

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder completion(String completion) {
            this.completion = completion;
            return this;
        }

        public Builder procStepName(String procStepName) {
            this.procStepName = procStepName;
            return this;
        }

        public Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public Builder smfid(String smfid) {
            this.smfid = smfid;
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public Builder stepNumber(Long stepNumber) {
            this.stepNumber = stepNumber;
            return this;
        }

        public JobStepData build() {
            return new JobStepData(this);
        }
    }
}

