/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.response;

import java.util.Optional;
import java.util.OptionalLong;
import zowe.client.sdk.zosmfinfo.response.DefinedSystem;

public class ZosmfSystemsResponse {
    private final Long numRows;
    private final DefinedSystem[] definedSystems;

    private ZosmfSystemsResponse(Builder builder) {
        this.numRows = builder.numRows;
        this.definedSystems = builder.definedSystems;
    }

    public Optional<DefinedSystem[]> getDefinedSystems() {
        return Optional.ofNullable(this.definedSystems);
    }

    public OptionalLong getNumRows() {
        return this.numRows == null ? OptionalLong.empty() : OptionalLong.of(this.numRows);
    }

    public String toString() {
        return "ZosmfSystemsResponse{numRows=" + this.numRows + ", definedSystems=" + this.definedSystems + "}";
    }

    public static class Builder {
        private Long numRows;
        private DefinedSystem[] definedSystems;

        public Builder definedSystems(DefinedSystem[] definedSystems) {
            this.definedSystems = definedSystems;
            return this;
        }

        public Builder numRows(Long numRows) {
            this.numRows = numRows;
            return this;
        }

        public ZosmfSystemsResponse build() {
            return new ZosmfSystemsResponse(this);
        }
    }
}

