/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnRename {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private String url;

    public DsnRename(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    DsnRename(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response dataSetName(String dataSetName, String newDataSetName) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(dataSetName, "dataSetName");
        ValidateUtils.checkIllegalParameter(newDataSetName, "newDataSetName");
        this.setUrl(newDataSetName);
        return this.executeCommon(dataSetName);
    }

    public Response memberName(String fromDataSetName, String memberName, String newMemberName) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fromDataSetName, "fromDataSetName");
        ValidateUtils.checkIllegalParameter(fromDataSetName, "fromDataSetName");
        ValidateUtils.checkIllegalParameter(memberName, "memberName");
        this.setUrl(fromDataSetName, newMemberName);
        return this.executeCommon(fromDataSetName, memberName);
    }

    private void setUrl(String ... args) {
        this.url = this.connection.getZosmfUrl() + "/restfiles/ds/" + EncodeUtils.encodeURIComponent(args[0]);
        if (args.length > 1) {
            this.url = this.url + "(" + EncodeUtils.encodeURIComponent(args[1]) + ")";
        }
    }

    private Response executeCommon(String ... args) throws ZosmfRequestException {
        HashMap<String, Object> renameMap = new HashMap<String, Object>();
        renameMap.put("request", "rename");
        HashMap<String, String> fromDataSetReq = new HashMap<String, String>();
        fromDataSetReq.put("dsn", args[0]);
        if (args.length > 1) {
            fromDataSetReq.put("member", args[1]);
        }
        JSONObject fromDataSetObj = new JSONObject(fromDataSetReq);
        renameMap.put("from-dataset", fromDataSetObj);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(this.url);
        this.request.setBody(new JSONObject(renameMap).toString());
        return this.request.executeRequest();
    }
}

