/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.response;

import java.util.Optional;
import java.util.OptionalLong;

public class ZosLogItem {
    private final String cart;
    private final String color;
    private final String jobName;
    private final String message;
    private final String messageId;
    private final String replyId;
    private final String system;
    private final String type;
    private final String subType;
    private final String time;
    private final Long timeStamp;

    private ZosLogItem(Builder builder) {
        this.cart = builder.cart;
        this.color = builder.color;
        this.jobName = builder.jobName;
        this.message = builder.message;
        this.messageId = builder.messageId;
        this.replyId = builder.replyId;
        this.system = builder.system;
        this.type = builder.type;
        this.subType = builder.subType;
        this.time = builder.time;
        this.timeStamp = builder.timeStamp;
    }

    public Optional<String> getCart() {
        return Optional.ofNullable(this.cart);
    }

    public Optional<String> getColor() {
        return Optional.ofNullable(this.color);
    }

    public Optional<String> getJobName() {
        return Optional.ofNullable(this.jobName);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Optional<String> getMessageId() {
        return Optional.ofNullable(this.messageId);
    }

    public Optional<String> getReplyId() {
        return Optional.ofNullable(this.replyId);
    }

    public Optional<String> getSystem() {
        return Optional.ofNullable(this.system);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getSubType() {
        return Optional.ofNullable(this.subType);
    }

    public Optional<String> getTime() {
        return Optional.ofNullable(this.time);
    }

    public OptionalLong getTimeStamp() {
        return this.timeStamp == null ? OptionalLong.empty() : OptionalLong.of(this.timeStamp);
    }

    public static class Builder {
        private String cart;
        private String color;
        private String jobName;
        private String message;
        private String messageId;
        private String replyId;
        private String system;
        private String type;
        private String subType;
        private String time;
        private Long timeStamp;

        public Builder cart(String cart) {
            this.cart = cart;
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder replyId(String replyId) {
            this.replyId = replyId;
            return this;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public Builder time(String time) {
            this.time = time;
            return this;
        }

        public Builder timeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public ZosLogItem build() {
            return new ZosLogItem(this);
        }
    }
}

