/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfHeaders;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.JobModifyInputData;
import zowe.client.sdk.zosjobs.response.Job;

public class JobDelete {
    private static final Logger LOG = LoggerFactory.getLogger(JobDelete.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public JobDelete(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    JobDelete(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public Response delete(String jobName, String jobId, String version) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.deleteCommon(new JobModifyInputData.Builder(jobName, jobId).version(version).build());
    }

    public Response deleteByJob(Job job, String version) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        String jobName = job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty"));
        String jobId = job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty"));
        return this.deleteCommon(new JobModifyInputData.Builder(jobName, jobId).version(version).build());
    }

    public Response deleteCommon(JobModifyInputData modifyInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(modifyInputData == null, "jobModifyInputData is null");
        String url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + modifyInputData.getJobName().get() + "/" + modifyInputData.getJobId().get();
        HashMap<String, String> headers = new HashMap<String, String>();
        String version = modifyInputData.getVersion().orElse("1.0");
        if ("1.0".equals(version)) {
            LOG.debug("version 1.0 specified which will result in asynchronous processing for the request");
            headers.put((String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_1").get(0), (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_1").get(1));
        } else if ("2.0".equals(version)) {
            LOG.debug("version 2.0 specified which will result in synchronous processing for the request");
            headers.put((String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_2").get(0), (String)ZosmfHeaders.HEADERS.get((Object)"X_IBM_JOB_MODIFY_VERSION_2").get(1));
        } else {
            throw new IllegalArgumentException("invalid version specified");
        }
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

