/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.utility.timer.WaitUtil;
import zowe.client.sdk.zosjobs.input.CommonJobInputData;
import zowe.client.sdk.zosjobs.input.JobGetInputData;
import zowe.client.sdk.zosjobs.input.JobMonitorInputData;
import zowe.client.sdk.zosjobs.methods.JobGet;
import zowe.client.sdk.zosjobs.response.CheckJobStatus;
import zowe.client.sdk.zosjobs.response.Job;
import zowe.client.sdk.zosjobs.response.JobFile;
import zowe.client.sdk.zosjobs.types.JobStatus;

public class JobMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(JobMonitor.class);
    public static final int DEFAULT_ATTEMPTS = 1000;
    public static final int DEFAULT_LINE_LIMIT = 1000;
    public static final JobStatus.Type DEFAULT_STATUS = JobStatus.Type.OUTPUT;
    public static final int DEFAULT_WATCH_DELAY = 3000;
    private final ZosConnection connection;
    private int attempts = 1000;
    private int watchDelay = 3000;
    private int lineLimit = 1000;

    public JobMonitor(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    public JobMonitor(ZosConnection connection, int attempts) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
        this.attempts = attempts;
    }

    public JobMonitor(ZosConnection connection, int attempts, int watchDelay) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
        this.attempts = attempts;
        this.watchDelay = watchDelay;
    }

    public JobMonitor(ZosConnection connection, int attempts, int watchDelay, int lineLimit) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
        this.attempts = attempts;
        this.watchDelay = watchDelay;
        this.lineLimit = lineLimit;
    }

    private boolean checkMessage(JobMonitorInputData monitorInputData, String message) throws ZosmfRequestException {
        int lineLimit;
        JobGet getJobs = new JobGet(this.connection);
        JobGetInputData filter = new JobGetInputData.Builder("*").jobId(monitorInputData.getJobId().orElse("")).prefix(monitorInputData.getJobName().orElse("")).build();
        List<Job> jobs = getJobs.getCommon(filter);
        if (jobs.isEmpty()) {
            throw new IllegalStateException("job does not exist");
        }
        List<JobFile> files = getJobs.getSpoolFilesByJob(jobs.get(0));
        String[] output = getJobs.getSpoolContent(files.get(0)).split("\n");
        int size = output.length;
        int start = size < (lineLimit = monitorInputData.getLineLimit().orElse(1000)) ? 0 : size - lineLimit;
        for (int i = start; i < size; ++i) {
            LOG.debug(output[i]);
            if (!output[i].contains(message)) continue;
            return true;
        }
        return false;
    }

    private CheckJobStatus checkStatus(JobMonitorInputData monitorInputData) throws ZosmfRequestException {
        return this.checkStatus(monitorInputData, false);
    }

    private CheckJobStatus checkStatus(JobMonitorInputData monitorInputData, boolean isStepData) throws ZosmfRequestException {
        Job job;
        JobGet getJobs = new JobGet(this.connection);
        String statusNameCheck = monitorInputData.getJobStatus().orElse(DEFAULT_STATUS).toString();
        if (statusNameCheck.equals((job = getJobs.getStatusCommon(new CommonJobInputData(monitorInputData.getJobId().orElse(""), monitorInputData.getJobName().orElse(""), isStepData))).getStatus().orElse(DEFAULT_STATUS.toString()))) {
            return new CheckJobStatus(true, job);
        }
        String invalidStatusMsg = "Invalid status when checking for status ordering.";
        int orderIndexOfDesiredJobStatus = this.getOrderIndexOfStatus(statusNameCheck);
        if (orderIndexOfDesiredJobStatus == -1) {
            throw new IllegalStateException("Invalid status when checking for status ordering.");
        }
        int orderIndexOfCurrRunningJobStatus = this.getOrderIndexOfStatus(job.getStatus().orElseThrow(() -> new IllegalStateException("job status not specified")));
        if (orderIndexOfCurrRunningJobStatus == -1) {
            throw new IllegalStateException("Invalid status when checking for status ordering.");
        }
        if (orderIndexOfCurrRunningJobStatus > orderIndexOfDesiredJobStatus) {
            return new CheckJobStatus(true, job);
        }
        return new CheckJobStatus(false, job);
    }

    private int getOrderIndexOfStatus(String statusName) {
        for (int i = 0; i < JobStatus.Order.length; ++i) {
            if (!statusName.equals(JobStatus.Order[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean isRunning(JobMonitorInputData monitorInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(monitorInputData == null, "monitorInputData is null");
        JobGet getJobs = new JobGet(this.connection);
        String jobName = monitorInputData.getJobName().orElse("");
        String jobId = monitorInputData.getJobId().orElse("");
        String status = getJobs.getStatusValue(jobName, jobId);
        return !JobStatus.Type.INPUT.toString().equals(status) && !JobStatus.Type.OUTPUT.toString().equals(status);
    }

    private boolean pollByMessage(JobMonitorInputData monitorInputData, String message) throws ZosmfRequestException {
        boolean shouldContinue;
        int timeoutVal = monitorInputData.getWatchDelay().orElse(3000);
        int numOfAttempts = 0;
        int maxAttempts = monitorInputData.getAttempts().orElse(1000);
        LOG.info("Waiting for message \"{}\"", (Object)message);
        do {
            boolean messageFound;
            boolean bl = shouldContinue = !(messageFound = this.checkMessage(monitorInputData, message)) && maxAttempts > 0 && ++numOfAttempts < maxAttempts;
            if (!shouldContinue) continue;
            WaitUtil.wait(timeoutVal);
            if (!this.isRunning(monitorInputData)) {
                return false;
            }
            LOG.info("Waiting for message \"{}\"", (Object)message);
        } while (shouldContinue);
        return numOfAttempts != maxAttempts;
    }

    private Job pollByStatus(JobMonitorInputData monitorInputData) throws ZosmfRequestException {
        CheckJobStatus checkJobStatus;
        boolean shouldContinue;
        int timeoutVal = monitorInputData.getWatchDelay().orElse(3000);
        int numOfAttempts = 0;
        int maxAttempts = monitorInputData.getAttempts().orElse(1000);
        String statusName = monitorInputData.getJobStatus().orElse(DEFAULT_STATUS).toString();
        LOG.info("Waiting for status \"{}\"", (Object)statusName);
        do {
            boolean expectedStatus;
            boolean bl = shouldContinue = !(expectedStatus = (checkJobStatus = this.checkStatus(monitorInputData)).isStatusFound()) && maxAttempts > 0 && ++numOfAttempts < maxAttempts;
            if (shouldContinue) {
                WaitUtil.wait(timeoutVal);
                LOG.info("Waiting for status \"{}\"", (Object)statusName);
                continue;
            }
            try {
                checkJobStatus = this.checkStatus(monitorInputData, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (shouldContinue);
        if (numOfAttempts == maxAttempts) {
            throw new IllegalStateException("Desired status not seen. The number of maximum attempts reached.");
        }
        return checkJobStatus.getJob();
    }

    public boolean waitByMessage(Job job, String message) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.waitMessageCommon(new JobMonitorInputData.Builder(job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty")), job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty"))).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build(), message);
    }

    public boolean waitByMessage(String jobName, String jobId, String message) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        ValidateUtils.checkIllegalParameter(message, "message");
        return this.waitMessageCommon(new JobMonitorInputData.Builder(jobName, jobId).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build(), message);
    }

    public Job waitByOutputStatus(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.waitStatusCommon(new JobMonitorInputData.Builder(job.getJobName().orElseThrow(() -> new IllegalArgumentException("jobName is either null or empty")), job.getJobId().orElseThrow(() -> new IllegalArgumentException("jobId is either null or empty"))).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitByOutputStatus(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.waitStatusCommon(new JobMonitorInputData.Builder(jobName, jobId).jobStatus(JobStatus.Type.OUTPUT).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitByStatus(Job job, JobStatus.Type statusType) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.waitStatusCommon(new JobMonitorInputData.Builder(job.getJobName().orElse(""), job.getJobId().orElse("")).jobStatus(statusType).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public Job waitByStatus(String jobName, String jobId, JobStatus.Type statusType) throws ZosmfRequestException {
        return this.waitStatusCommon(new JobMonitorInputData.Builder(jobName, jobId).jobStatus(statusType).attempts(this.attempts).watchDelay(this.watchDelay).build());
    }

    public boolean waitMessageCommon(JobMonitorInputData monitorInputData, String message) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(monitorInputData == null, "monitorInputData is null");
        ValidateUtils.checkIllegalParameter(message, "message");
        if (monitorInputData.getAttempts().isEmpty()) {
            monitorInputData.setAttempts(this.attempts);
        }
        if (monitorInputData.getWatchDelay().isEmpty()) {
            monitorInputData.setWatchDelay(this.watchDelay);
        }
        if (monitorInputData.getLineLimit().isEmpty()) {
            monitorInputData.setLineLimit(this.lineLimit);
        }
        return this.pollByMessage(monitorInputData, message);
    }

    public Job waitStatusCommon(JobMonitorInputData monitorInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(monitorInputData == null, "monitorInputData is null");
        if (monitorInputData.getJobStatus().isEmpty()) {
            monitorInputData.setJobStatus(DEFAULT_STATUS);
        }
        if (monitorInputData.getAttempts().isEmpty()) {
            monitorInputData.setAttempts(this.attempts);
        }
        if (monitorInputData.getWatchDelay().isEmpty()) {
            monitorInputData.setWatchDelay(this.watchDelay);
        }
        return this.pollByStatus(monitorInputData);
    }
}

