/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.input;

import java.util.Optional;
import zowe.client.sdk.zosfiles.dsn.types.AttributeType;

public class DsnListInputData {
    private final String volume;
    private final AttributeType attribute;
    private final String maxLength;
    private final String start;
    private final String recall;
    private final String pattern;
    private final String responseTimeout;

    private DsnListInputData(Builder builder) {
        this.volume = builder.volume;
        this.attribute = builder.attribute;
        this.maxLength = builder.maxLength;
        this.start = builder.start;
        this.recall = builder.recall;
        this.pattern = builder.pattern;
        this.responseTimeout = builder.responseTimeout;
    }

    public Optional<AttributeType> getAttribute() {
        return Optional.ofNullable(this.attribute);
    }

    public Optional<String> getMaxLength() {
        return Optional.ofNullable(this.maxLength);
    }

    public Optional<String> getPattern() {
        return Optional.ofNullable(this.pattern);
    }

    public Optional<String> getRecall() {
        return Optional.ofNullable(this.recall);
    }

    public Optional<String> getResponseTimeout() {
        return Optional.ofNullable(this.responseTimeout);
    }

    public Optional<String> getStart() {
        return Optional.ofNullable(this.start);
    }

    public Optional<String> getVolume() {
        return Optional.ofNullable(this.volume);
    }

    public String toString() {
        return "DsnListInputData{volume=" + this.volume + ", attribute=" + this.attribute + ", maxLength=" + this.maxLength + ", start=" + this.start + ", recall=" + this.recall + ", pattern=" + this.pattern + ", responseTimeout=" + this.responseTimeout + "}";
    }

    public static class Builder {
        private String volume;
        private AttributeType attribute;
        private String maxLength;
        private String start;
        private String recall;
        private String pattern;
        private String responseTimeout;

        public Builder volume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder attribute(AttributeType attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder start(String start) {
            this.start = start;
            return this;
        }

        public Builder recall(String recall) {
            this.recall = recall;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder responseTimeout(String responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public DsnListInputData build() {
            return new DsnListInputData(this);
        }
    }
}

