/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;

public class UssWriteInputData {
    private final String textContent;
    private final byte[] binaryContent;
    private final String fileEncoding;
    private final boolean crlf;
    private final boolean binary;

    public UssWriteInputData(Builder builder) {
        this.textContent = builder.textContent;
        this.binaryContent = builder.binaryContent;
        this.fileEncoding = builder.fileEncoding;
        this.crlf = builder.crlf;
        this.binary = builder.binary;
    }

    public Optional<String> getTextContent() {
        return Optional.ofNullable(this.textContent);
    }

    public Optional<byte[]> getBinaryContent() {
        return Optional.ofNullable(this.binaryContent);
    }

    public Optional<String> getFileEncoding() {
        return Optional.ofNullable(this.fileEncoding);
    }

    public boolean isCrlf() {
        return this.crlf;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String toString() {
        return "UssWriteInputData{textContent=" + this.textContent + ", binaryContent=" + this.binaryContent + ", fileEncoding=" + this.fileEncoding + ", crlf=" + this.crlf + ", binary=" + this.binary + "}";
    }

    public static class Builder {
        private String textContent;
        private byte[] binaryContent;
        private String fileEncoding;
        private boolean crlf = false;
        private boolean binary = false;

        public Builder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public Builder binaryContent(byte[] binaryContent) {
            this.binaryContent = binaryContent;
            return this;
        }

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        public Builder crlf(boolean crlf) {
            this.crlf = crlf;
            return this;
        }

        public Builder binary(boolean binary) {
            this.binary = binary;
            return this;
        }

        public UssWriteInputData build() {
            return new UssWriteInputData(this);
        }
    }
}

