/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.service;

import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.DeleteJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ResponseUtil;
import zowe.client.sdk.utility.ValidateUtils;

public class TsoStopService {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public TsoStopService(ZosConnection connection) {
        this.connection = connection;
    }

    TsoStopService(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof DeleteJsonZosmfRequest)) {
            throw new IllegalStateException("DELETE_JSON request type required");
        }
        this.request = request;
    }

    public void stopTso(String sessionId) throws ZosmfRequestException {
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/" + sessionId;
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.DELETE_JSON);
        }
        this.request.setUrl(url);
        ResponseUtil.getResponseStr(this.request, "Failed to end tso session.");
    }
}

