/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;

public class UssCreateZfsInputData {
    private final Integer owner;
    private final Integer group;
    private final Integer perms;
    private final Integer cylsPri;
    private final Integer cylsSec;
    private final String storageClass;
    private final String managementClass;
    private final String dataClass;
    private final List<String> volumes;
    private final Integer timeout;
    private final String system;

    private UssCreateZfsInputData(Builder builder) {
        this.owner = builder.owner;
        this.group = builder.group;
        this.perms = builder.perms;
        this.cylsPri = builder.cylsPri;
        this.cylsSec = builder.cylsSec;
        this.storageClass = builder.storageClass;
        this.managementClass = builder.managementClass;
        this.dataClass = builder.dataClass;
        this.volumes = builder.volumes;
        this.timeout = builder.timeout;
        this.system = builder.system;
    }

    public OptionalInt getOwner() {
        return this.owner == null ? OptionalInt.empty() : OptionalInt.of(this.owner);
    }

    public OptionalInt getGroup() {
        return this.group == null ? OptionalInt.empty() : OptionalInt.of(this.group);
    }

    public OptionalInt getPerms() {
        return this.perms == null ? OptionalInt.empty() : OptionalInt.of(this.perms);
    }

    public OptionalInt getCylsPri() {
        return this.cylsPri == null ? OptionalInt.empty() : OptionalInt.of(this.cylsPri);
    }

    public OptionalInt getCylsSec() {
        return this.cylsSec == null ? OptionalInt.empty() : OptionalInt.of(this.cylsSec);
    }

    public Optional<String> getStorageClass() {
        return Optional.ofNullable(this.storageClass);
    }

    public Optional<String> getManagementClass() {
        return Optional.ofNullable(this.managementClass);
    }

    public Optional<String> getDataClass() {
        return Optional.ofNullable(this.dataClass);
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public OptionalInt getTimeout() {
        return this.timeout == null ? OptionalInt.empty() : OptionalInt.of(this.timeout);
    }

    public Optional<String> getSystem() {
        return Optional.ofNullable(this.system);
    }

    public String toString() {
        return "UssCreateZfsInputData{owner=" + this.owner + ", group=" + this.group + ", perms=" + this.perms + ", cylsPri=" + this.cylsPri + ", cylsSec=" + this.cylsSec + ", storageClass=" + this.storageClass + ", managementClass=" + this.managementClass + ", dataClass=" + this.dataClass + ", volumes=" + this.volumes + ", timeout=" + this.timeout + ", system=" + this.system + "}";
    }

    public static class Builder {
        private Integer owner;
        private Integer group;
        private Integer perms;
        private final Integer cylsPri;
        private Integer cylsSec;
        private String storageClass;
        private String managementClass;
        private String dataClass;
        private List<String> volumes = new ArrayList<String>();
        private Integer timeout;
        private String system;

        public Builder(Integer cylsPri) {
            ValidateUtils.checkNullParameter(cylsPri == null, "cylsPri is null");
            ValidateUtils.checkIllegalParameter(cylsPri <= 0, "specify cylsPri greater than 0");
            this.cylsPri = cylsPri;
        }

        public Builder owner(Integer owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(Integer group) {
            this.group = group;
            return this;
        }

        public Builder perms(Integer perms) {
            this.perms = perms;
            return this;
        }

        public Builder cylsSec(Integer cylsSec) {
            this.cylsSec = cylsSec;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder managementClass(String managementClass) {
            this.managementClass = managementClass;
            return this;
        }

        public Builder dataClass(String dataClass) {
            this.dataClass = dataClass;
            return this;
        }

        public Builder volumes(List<String> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public UssCreateZfsInputData build() {
            return new UssCreateZfsInputData(this);
        }
    }
}

