/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutStreamZosmfRequest;
import zowe.client.sdk.rest.PutTextZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.UssWriteInputData;

public class UssWrite {
    private static final Logger LOG = LoggerFactory.getLogger(UssWrite.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssWrite(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssWrite(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        this.request = request;
    }

    public Response writeText(String fileNamePath, String content) throws ZosmfRequestException {
        return this.writeCommon(fileNamePath, new UssWriteInputData.Builder().textContent(content).build());
    }

    public Response writeBinary(String fileNamePath, byte[] content) throws ZosmfRequestException {
        return this.writeCommon(fileNamePath, new UssWriteInputData.Builder().binaryContent(content).binary(true).build());
    }

    public Response writeCommon(String fileNamePath, UssWriteInputData writeInputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fileNamePath, "fileNamePath");
        ValidateUtils.checkNullParameter(writeInputData == null, "writeInputData is null");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(fileNamePath));
        HashMap<String, String> headers = new HashMap<String, String>();
        if (writeInputData.isBinary()) {
            headers.put("X-IBM-Data-Type", "binary;");
            if (writeInputData.getBinaryContent().isEmpty()) {
                LOG.debug("binaryContent is empty");
            }
            if (this.request == null || !(this.request instanceof PutStreamZosmfRequest)) {
                this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_STREAM);
            }
            this.request.setBody(writeInputData.getBinaryContent().orElse(new byte[0]));
        } else {
            StringBuilder textHeader = new StringBuilder("text");
            writeInputData.getFileEncoding().ifPresent(encoding -> textHeader.append(";fileEncoding=").append((String)encoding));
            if (writeInputData.isCrlf()) {
                textHeader.append(";crlf=true");
            }
            textHeader.append(";");
            headers.put("X-IBM-Data-Type", textHeader.toString());
            if (writeInputData.getTextContent().isEmpty()) {
                LOG.debug("textContent is empty");
            }
            if (this.request == null || !(this.request instanceof PutTextZosmfRequest)) {
                this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_TEXT);
            }
            this.request.setBody(writeInputData.getTextContent().orElse(""));
        }
        this.request.setHeaders(headers);
        this.request.setUrl(url);
        return this.request.executeRequest();
    }
}

