/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.response;

import java.util.Optional;
import zowe.client.sdk.zosmfinfo.model.ZosmfPlugin;

public class ZosmfInfoResponse {
    private final String zosVersion;
    private final String zosmfPort;
    private final String zosmfVersion;
    private final String zosmfHostName;
    private final String zosmfSafRealm;
    private final String zosmfFullVersion;
    private final String apiVersion;
    private final ZosmfPlugin[] zosmfPluginsInfo;

    private ZosmfInfoResponse(Builder builder) {
        this.zosVersion = builder.zosVersion;
        this.zosmfPort = builder.zosmfPort;
        this.zosmfVersion = builder.zosmfVersion;
        this.zosmfHostName = builder.zosmfHostName;
        this.zosmfSafRealm = builder.zosmfSafRealm;
        this.zosmfFullVersion = builder.zosmfFullVersion;
        this.apiVersion = builder.apiVersion;
        this.zosmfPluginsInfo = builder.zosmfPluginsInfo;
    }

    public Optional<String> getApiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> getZosVersion() {
        return Optional.ofNullable(this.zosVersion);
    }

    public Optional<String> getZosmfFullVersion() {
        return Optional.ofNullable(this.zosmfFullVersion);
    }

    public Optional<String> getZosmfHostName() {
        return Optional.ofNullable(this.zosmfHostName);
    }

    public Optional<ZosmfPlugin[]> getZosmfPluginsInfo() {
        return Optional.ofNullable(this.zosmfPluginsInfo);
    }

    public Optional<String> getZosmfPort() {
        return Optional.ofNullable(this.zosmfPort);
    }

    public Optional<String> getZosmfSafRealm() {
        return Optional.ofNullable(this.zosmfSafRealm);
    }

    public Optional<String> getZosmfVersion() {
        return Optional.ofNullable(this.zosmfVersion);
    }

    public String toString() {
        return "ZosmfInfoResponse{zosVersion=" + this.zosVersion + ", zosmfPort=" + this.zosmfPort + ", zosmfVersion=" + this.zosmfVersion + ", zosmfHostName=" + this.zosmfHostName + ", zosmfSafRealm=" + this.zosmfSafRealm + ", zosmfFullVersion=" + this.zosmfFullVersion + ", apiVersion=" + this.apiVersion + ", zosmfPluginsInfo=" + this.zosmfPluginsInfo + "}";
    }

    public static class Builder {
        private String zosVersion;
        private String zosmfPort;
        private String zosmfVersion;
        private String zosmfHostName;
        private String zosmfSafRealm;
        private String zosmfFullVersion;
        private String apiVersion;
        private ZosmfPlugin[] zosmfPluginsInfo;

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder zosVersion(String zosVersion) {
            this.zosVersion = zosVersion;
            return this;
        }

        public Builder zosmfFullVersion(String zosmfFullVersion) {
            this.zosmfFullVersion = zosmfFullVersion;
            return this;
        }

        public Builder zosmfHostName(String zosmfHostName) {
            this.zosmfHostName = zosmfHostName;
            return this;
        }

        public Builder zosmfPluginsInfo(ZosmfPlugin[] zosmfPluginsInfo) {
            this.zosmfPluginsInfo = zosmfPluginsInfo;
            return this;
        }

        public Builder zosmfPort(String zosmfPort) {
            this.zosmfPort = zosmfPort;
            return this;
        }

        public Builder zosmfSafRealm(String zosmfSafRealm) {
            this.zosmfSafRealm = zosmfSafRealm;
            return this;
        }

        public Builder zosmfVersion(String zosmfVersion) {
            this.zosmfVersion = zosmfVersion;
            return this;
        }

        public ZosmfInfoResponse build() {
            return new ZosmfInfoResponse(this);
        }
    }
}

