/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.UssMountInputData;
import zowe.client.sdk.zosfiles.uss.types.MountActionType;
import zowe.client.sdk.zosfiles.uss.types.MountModeType;

public class UssMount {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssMount(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssMount(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response mount(String fileSystemName, String mountPoint, String fsType) throws ZosmfRequestException {
        return this.mountCommon(fileSystemName, new UssMountInputData.Builder().action(MountActionType.MOUNT).mountPoint(mountPoint).fsType(fsType).mode(MountModeType.READ_WRITE).build());
    }

    public Response unmount(String fileSystemName) throws ZosmfRequestException {
        return this.mountCommon(fileSystemName, new UssMountInputData.Builder().action(MountActionType.UNMOUNT).build());
    }

    public Response mountCommon(String fileSystemName, UssMountInputData mountInputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fileSystemName, "fileSystemName");
        ValidateUtils.checkNullParameter(mountInputData == null, "mountInputData is null");
        ValidateUtils.checkIllegalParameter(mountInputData.getAction().isEmpty(), "mountInputData action not specified");
        String action = mountInputData.getAction().get().getValue();
        if ("MOUNT".equalsIgnoreCase(action)) {
            ValidateUtils.checkIllegalParameter(mountInputData.getMountPoint().isEmpty(), "mountPoint not specified");
            ValidateUtils.checkIllegalParameter(mountInputData.getFsType().isEmpty(), "fsType not specified");
        }
        String url = this.connection.getZosmfUrl() + "/restfiles/mfs/" + EncodeUtils.encodeURIComponent(fileSystemName);
        HashMap<String, String> mountMap = new HashMap<String, String>();
        mountMap.put("action", action);
        mountInputData.getMountPoint().ifPresent(str -> mountMap.put("mount-point", (String)str));
        mountInputData.getFsType().ifPresent(str -> mountMap.put("fs-type", (String)str));
        mountInputData.getMode().ifPresent(str -> mountMap.put("mode", str.getValue()));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(mountMap).toString());
        return this.request.executeRequest();
    }
}

