/*
 * Decompiled with CFR 0.152.
 */
package com.starxg.keytar;

import com.starxg.keytar.KeytarException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Keytar {
    private static volatile Keytar instance;

    private Keytar() {
    }

    public static Keytar getInstance() {
        if (instance == null) {
            return Keytar.getInstance(Keytar.class, "libkeytar", Keytar.getSuffix());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Keytar getInstance(Class<?> clazz, String classpathLibraryName, String libraryNameSuffix) {
        if (instance != null) return instance;
        Class<Keytar> clazz2 = Keytar.class;
        synchronized (Keytar.class) {
            if (instance != null) return instance;
            try {
                File tmpFile = File.createTempFile(classpathLibraryName, libraryNameSuffix);
                try (InputStream is = Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(classpathLibraryName + libraryNameSuffix), classpathLibraryName + libraryNameSuffix + " not found");
                     FileOutputStream os = new FileOutputStream(tmpFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = is.read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, bytesRead);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return Keytar.getInstance(tmpFile);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Keytar getInstance(File absoluteLibraryFile) {
        if (instance != null) return instance;
        Class<Keytar> clazz = Keytar.class;
        synchronized (Keytar.class) {
            if (instance != null) return instance;
            Keytar.loadSharedObject(absoluteLibraryFile);
            instance = new Keytar();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private native String _getPassword(String var1, String var2) throws KeytarException;

    private native void _setPassword(String var1, String var2, String var3) throws KeytarException;

    private native boolean _deletePassword(String var1, String var2) throws KeytarException;

    private native Map<String, String> _getCredentials(String var1) throws KeytarException;

    public String getPassword(String service, String account) throws KeytarException {
        return this._getPassword(Objects.requireNonNull(service, "service must not be null"), Objects.requireNonNull(account, "account must not be null"));
    }

    public void setPassword(String service, String account, String password) throws KeytarException {
        this._setPassword(Objects.requireNonNull(service, "service must not be null"), Objects.requireNonNull(account, "account must not be null"), Objects.requireNonNull(password, "password must not be null"));
    }

    public boolean deletePassword(String service, String account) throws KeytarException {
        return this._deletePassword(Objects.requireNonNull(service, "service must not be null"), Objects.requireNonNull(account, "account must not be null"));
    }

    public Map<String, String> getCredentials(String service) throws KeytarException {
        Map<String, String> credentials = this._getCredentials(Objects.requireNonNull(service, "service must not be null"));
        return credentials == null ? Collections.emptyMap() : credentials;
    }

    private static void loadSharedObject(File absoluteLibraryFile) {
        System.load(absoluteLibraryFile.getAbsolutePath());
    }

    private static String getSuffix() {
        String osArch = System.getProperty("os.arch");
        String cpuArch = null;
        if (osArch != null) {
            if ("amd64".equalsIgnoreCase(osArch = osArch.toLowerCase()) || "x86_64".equalsIgnoreCase(osArch)) {
                cpuArch = "x64";
            } else if ("x86".equalsIgnoreCase(osArch)) {
                cpuArch = "x86";
            } else if ("aarch64".equals(osArch) || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
                cpuArch = "arm64";
            }
        }
        if (cpuArch == null) {
            String sunArch = System.getProperty("sun.arch.data.model");
            if ("64".equals(sunArch)) {
                cpuArch = "x64";
            } else if ("32".equals(sunArch)) {
                cpuArch = "x86";
            }
        }
        String osName = System.getProperty("os.name");
        if (cpuArch == null) {
            throw new IllegalStateException(String.format("os.arch unknown, please report this to us: os.arch=%s, model=%s, os.name=%s", System.getProperty("os.arch"), System.getProperty("sun.arch.data.model"), osName));
        }
        if (osName.startsWith("Win")) {
            cpuArch = "-win32-" + cpuArch + ".dll";
        } else if (osName.startsWith("Mac")) {
            cpuArch = "-darwin-" + cpuArch + ".dylib";
        } else if (osName.startsWith("Linux")) {
            cpuArch = "-linux-" + cpuArch + ".so";
        }
        return cpuArch;
    }
}

