/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.parse;

import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.parse.JsonParse;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.model.ZosmfPlugin;
import zowe.client.sdk.zosmfinfo.response.ZosmfInfoResponse;

public final class SystemInfoJsonParse
implements JsonParse {
    private SystemInfoJsonParse() {
    }

    public static SystemInfoJsonParse getInstance() {
        return Holder.instance;
    }

    @Override
    public synchronized Object parseResponse(Object ... args) {
        ValidateUtils.checkNullParameter(args[0] == null, "data is null");
        JSONObject data = (JSONObject)args[0];
        ZosmfInfoResponse.Builder zosmfInfoResponse = new ZosmfInfoResponse.Builder().zosVersion(data.get("zos_version") != null ? (String)data.get("zos_version") : null).zosmfPort(data.get("zosmf_port") != null ? (String)data.get("zosmf_port") : null).zosmfVersion(data.get("zosmf_version") != null ? (String)data.get("zosmf_version") : null).zosmfHostName(data.get("zosmf_hostname") != null ? (String)data.get("zosmf_hostname") : null).zosmfSafRealm(data.get("zosmf_saf_realm") != null ? (String)data.get("zosmf_saf_realm") : null).apiVersion(data.get("api_version") != null ? (String)data.get("api_version") : null).zosmfFullVersion(data.get("zosmf_full_version") != null ? (String)data.get("zosmf_full_version") : null);
        ArrayList plugins = null;
        try {
            plugins = data.get("plugins") != null ? (JSONArray)data.get("plugins") : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (plugins != null) {
            int size = plugins.size();
            ZosmfPlugin[] zosmfPluginsInfo = new ZosmfPlugin[size];
            for (int i = 0; i < size; ++i) {
                zosmfPluginsInfo[i] = SystemInfoJsonParse.parseZosmfPluginInfo((JSONObject)plugins.get(i));
            }
            return zosmfInfoResponse.zosmfPluginsInfo(zosmfPluginsInfo).build();
        }
        return zosmfInfoResponse.build();
    }

    private static ZosmfPlugin parseZosmfPluginInfo(JSONObject data) {
        return new ZosmfPlugin.Builder().pluginVersion(data.get("pluginVersion") != null ? (String)data.get("pluginVersion") : null).pluginDefaultName(data.get("pluginDefaultName") != null ? (String)data.get("pluginDefaultName") : null).pluginStatus(data.get("pluginStatus") != null ? (String)data.get("pluginStatus") : null).build();
    }

    private static class Holder {
        private static final SystemInfoJsonParse instance = new SystemInfoJsonParse();

        private Holder() {
        }
    }
}

