/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.method;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ConsoleUtils;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.input.ConsoleCmdInputData;
import zowe.client.sdk.zosconsole.response.ConsoleCmdResponse;

public class ConsoleCmd {
    private static final String CMD = "cmd";
    private static final String SOL_KEY = "sol-key";
    private static final String SYSTEM = "system";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ConsoleCmd(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    ConsoleCmd(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public ConsoleCmdResponse issueCommand(String command) throws ZosmfRequestException {
        return this.issueCommandCommon("defcn", new ConsoleCmdInputData(command));
    }

    public ConsoleCmdResponse issueCommand(String command, String consoleName) throws ZosmfRequestException {
        return this.issueCommandCommon(consoleName, new ConsoleCmdInputData(command));
    }

    public ConsoleCmdResponse issueCommandCommon(String consoleName, ConsoleCmdInputData consoleInputData) throws ZosmfRequestException {
        JsonNode jsonNode;
        ValidateUtils.checkIllegalParameter(consoleName, "consoleName");
        ValidateUtils.checkNullParameter(consoleInputData == null, "consoleInputData is null");
        String url = this.connection.getZosmfUrl() + "/restconsoles/consoles/" + EncodeUtils.encodeURIComponent(consoleName);
        Map<String, String> issueMap = this.getIssueMap(consoleInputData);
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(issueMap).toString());
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no issue console response phrase")).toString();
        try {
            jsonNode = this.objectMapper.readTree(jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException(e.getMessage());
        }
        ConsoleCmdResponse response = this.objectMapper.convertValue((Object)jsonNode, ConsoleCmdResponse.class);
        if (consoleInputData.isProcessResponse()) {
            response.setCmdResponse(ConsoleUtils.processCmdResponse(response.getCmdResponse().orElse("")));
        }
        return response;
    }

    private Map<String, String> getIssueMap(ConsoleCmdInputData consoleInputData) {
        HashMap<String, String> issueMap = new HashMap<String, String>();
        issueMap.put(CMD, consoleInputData.getCmd());
        consoleInputData.getSolKey().ifPresent(solKey -> issueMap.put(SOL_KEY, (String)solKey));
        consoleInputData.getSystem().ifPresent(sys -> issueMap.put(SYSTEM, (String)sys));
        return issueMap;
    }
}

