/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosconsole.method;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.ConsoleUtils;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosconsole.response.ConsoleGetResponse;

public class ConsoleGet {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ConsoleGet(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    ConsoleGet(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ConsoleGetResponse getResponse(String responseKey) throws ZosmfRequestException {
        return this.getResponseCommon(responseKey, "", true);
    }

    public ConsoleGetResponse getResponse(String responseKey, String consoleName) throws ZosmfRequestException {
        return this.getResponseCommon(responseKey, consoleName, true);
    }

    public ConsoleGetResponse getResponseCommon(String responseKey, String consoleName, boolean processResponse) throws ZosmfRequestException {
        JsonNode jsonNode;
        ValidateUtils.checkIllegalParameter(responseKey, "responseKey");
        String url = this.connection.getZosmfUrl() + "/restconsoles/consoles/" + EncodeUtils.encodeURIComponent(consoleName.isBlank() ? "defcn" : consoleName) + "/solmsgs/" + responseKey;
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        String jsonStr = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no issue console response phrase")).toString();
        try {
            jsonNode = this.objectMapper.readTree(jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException(e.getMessage());
        }
        ConsoleGetResponse response = this.objectMapper.convertValue((Object)jsonNode, ConsoleGetResponse.class);
        if (processResponse) {
            response.setCmdResponse(ConsoleUtils.processCmdResponse(response.getCmdResponse().orElse("")));
        }
        return response;
    }
}

