/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.dsn.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;

public class DsnCopyInputData {
    private final String fromVolser;
    private final String fromDataSet;
    private final String toVolser;
    private final String toDataSet;
    private final boolean replace;
    private final boolean copyAllMembers;

    private DsnCopyInputData(Builder builder) {
        this.fromVolser = builder.fromVolser;
        this.fromDataSet = builder.fromDataSet;
        this.toVolser = builder.toVolser;
        this.toDataSet = builder.toDataSet;
        this.replace = builder.replace;
        this.copyAllMembers = builder.copyAllMembers;
    }

    public Optional<String> getFromDataSet() {
        return Optional.ofNullable(this.fromDataSet);
    }

    public Optional<String> getFromVolser() {
        return Optional.ofNullable(this.fromVolser);
    }

    public Optional<String> getToDataSet() {
        return Optional.ofNullable(this.toDataSet);
    }

    public Optional<String> getToVolser() {
        return Optional.ofNullable(this.toVolser);
    }

    public boolean isCopyAllMembers() {
        return this.copyAllMembers;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public String toString() {
        return "DsnCopyInputData{fromVolser=" + this.fromVolser + ", fromDataSet=" + this.fromDataSet + ", toVolser=" + this.toVolser + ", toDataSet=" + this.toDataSet + ", replace=" + this.replace + "}";
    }

    public static class Builder {
        private String fromVolser;
        private String fromDataSet;
        private String toVolser;
        private String toDataSet;
        private boolean replace = true;
        private boolean copyAllMembers = false;

        public Builder copyAllMembers(boolean value) {
            this.copyAllMembers = value;
            return this;
        }

        public Builder fromDataSet(String dataSet) {
            ValidateUtils.checkNullParameter(dataSet == null, "fromDataSet is null");
            ValidateUtils.checkNullParameter(dataSet.isEmpty(), "fromDataSet not specified");
            this.fromDataSet = dataSet;
            return this;
        }

        public Builder fromVolser(String volser) {
            this.fromVolser = volser;
            return this;
        }

        public Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public Builder toDataSet(String dataSet) {
            ValidateUtils.checkNullParameter(dataSet == null, "toDataSet is null");
            ValidateUtils.checkNullParameter(dataSet.isEmpty(), "toDataSet not specified");
            this.toDataSet = dataSet;
            return this;
        }

        public Builder toVolser(String volser) {
            this.toVolser = volser;
            return this;
        }

        public DsnCopyInputData build() {
            return new DsnCopyInputData(this);
        }
    }
}

